/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.quest;

import com.feliscape.sanguis.content.quest.registry.QuestType;
import com.feliscape.sanguis.data.loot.SanguisQuestLootTables;
import com.feliscape.sanguis.registry.SanguisCriteriaTriggers;
import com.feliscape.sanguis.registry.custom.SanguisRegistries;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public abstract class HunterQuest {
    public static final Codec<HunterQuest> TYPED_CODEC = SanguisRegistries.QUEST_TYPES.byNameCodec().dispatch("requirement", HunterQuest::type, QuestType::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, HunterQuest> TYPED_STREAM_CODEC = ByteBufCodecs.registry(SanguisRegistries.Keys.QUEST_TYPES).dispatch(HunterQuest::type, QuestType::streamCodec);
    protected boolean isCompleted = false;
    protected boolean isDirty = false;
    protected int duration = 72000;

    protected HunterQuest() {
    }

    protected HunterQuest(int duration) {
        this.duration = duration;
    }

    protected HunterQuest(int duration, boolean isCompleted) {
        this.duration = duration;
        this.isCompleted = isCompleted;
    }

    public static Tag serialize(HunterQuest quest) {
        return (Tag)TYPED_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)quest).getOrThrow();
    }

    public void complete(Player player) {
        if (!this.checkCompleted(player)) {
            return;
        }
        this.onComplete(player);
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable loot = serverLevel.getServer().reloadableRegistries().getLootTable(SanguisQuestLootTables.BASIC_REWARD);
            ObjectArrayList items = loot.getRandomItems(new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.GIFT));
            for (ItemStack itemStack : items) {
                if (player.getInventory().add(itemStack)) continue;
                player.drop(itemStack, true);
            }
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SanguisCriteriaTriggers.QUEST_COMPLETED.get().trigger(serverPlayer, this);
        }
    }

    public void tick(Player player) {
        if (this.duration > 0) {
            --this.duration;
        }
        if (this.isDirty()) {
            this.updateIsCompleted(player);
        }
    }

    public abstract QuestType<? extends HunterQuest> type();

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isInfiniteDuration() {
        return this.duration == -1;
    }

    public void makeInfinite() {
        this.duration = -1;
    }

    public int getDuration() {
        return this.duration;
    }

    public abstract boolean checkCompleted(Player var1);

    public abstract void onComplete(Player var1);

    public abstract Component getTypeName();

    public abstract Component getTitle();

    public void updateIsCompleted(Player player) {
        this.isCompleted = this.checkCompleted(player);
    }

    public boolean is(HolderSet<QuestType<?>> holders) {
        return holders.contains(this.type().builtInRegistryHolder());
    }
}

