/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.quest;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.content.quest.registry.QuestType;
import com.feliscape.sanguis.data.loot.SanguisQuestLootTables;
import com.feliscape.sanguis.registry.SanguisQuestTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class ItemQuest
extends HunterQuest {
    public static final MapCodec<ItemQuest> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("duration").forGetter(HunterQuest::getDuration), (App)Codec.BOOL.fieldOf("completed").forGetter(HunterQuest::isCompleted), (App)ItemStack.CODEC.listOf().fieldOf("items").forGetter(ItemQuest::getItems)).apply((Applicative)inst, ItemQuest::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemQuest> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, HunterQuest::getDuration, (StreamCodec)ByteBufCodecs.BOOL, HunterQuest::isCompleted, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemQuest::getItems, ItemQuest::new);
    private final List<ItemStack> items;

    public ItemQuest(List<ItemStack> items) {
        this.items = items;
    }

    public ItemQuest(int duration, boolean isCompleted, List<ItemStack> items) {
        super(duration, isCompleted);
        this.items = items;
    }

    @Override
    public void tick(Player player) {
        if (player.tickCount % 5 == 0) {
            this.setDirty(true);
        }
        super.tick(player);
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public QuestType<ItemQuest> type() {
        return SanguisQuestTypes.FETCH_ITEMS.get();
    }

    @Override
    public boolean checkCompleted(Player player) {
        if (player == null) {
            return false;
        }
        Inventory inventory = player.getInventory();
        ArrayList<ItemStack> itemsLeft = new ArrayList<ItemStack>(this.items.stream().map(ItemStack::copy).toList());
        block0: for (int j = 0; j < inventory.getContainerSize(); ++j) {
            ItemStack inventoryItem = inventory.getItem(j).copy();
            for (int i = 0; i < itemsLeft.size(); ++i) {
                ItemStack requiredItem = itemsLeft.get(i);
                if (inventoryItem.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)inventoryItem, (ItemStack)requiredItem)) continue;
                if (inventoryItem.getCount() < requiredItem.getCount()) {
                    requiredItem.shrink(inventoryItem.getCount());
                    continue block0;
                }
                itemsLeft.set(i, ItemStack.EMPTY);
                if (inventoryItem.getCount() <= requiredItem.getCount()) continue block0;
                inventoryItem.shrink(requiredItem.getCount());
            }
        }
        return itemsLeft.stream().allMatch(ItemStack::isEmpty);
    }

    @Override
    public void onComplete(Player player) {
        Inventory inventory = player.getInventory();
        ArrayList<ItemStack> itemsLeft = new ArrayList<ItemStack>(this.items.stream().map(ItemStack::copy).toList());
        block0: for (ItemStack requiredItem : itemsLeft) {
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack inventoryItem = inventory.getItem(i);
                if (inventoryItem.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)inventoryItem, (ItemStack)requiredItem)) continue;
                if (inventoryItem.getCount() > requiredItem.getCount()) {
                    inventoryItem.shrink(requiredItem.getCount());
                    continue block0;
                }
                requiredItem.shrink(inventoryItem.getCount());
                inventory.removeItem(inventoryItem);
                if (requiredItem.getCount() <= 0) continue block0;
            }
        }
    }

    @Override
    public Component getTypeName() {
        return Component.translatable((String)"quest.sanguis.fetch_items.name").withStyle(ChatFormatting.GRAY);
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)"quest.sanguis.fetch_items.title", (Object[])new Object[]{this.items.getFirst().getDisplayName()}).withStyle(ChatFormatting.WHITE);
    }

    public static ItemQuest create(ServerLevel level) {
        LootTable table = level.getServer().reloadableRegistries().getLootTable(SanguisQuestLootTables.ItemRequirements.HUNT_VAMPIRE);
        if (table == LootTable.EMPTY) {
            Sanguis.LOGGER.warn("ItemQuest.create couldn't find the appropriate loot table");
        }
        LootParams params = new LootParams.Builder(level).create(LootContextParamSets.EMPTY);
        ItemQuest itemQuest = new ItemQuest((List<ItemStack>)table.getRandomItems(params));
        return itemQuest;
    }
}

