/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.quest;

import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.content.quest.registry.QuestType;
import com.feliscape.sanguis.registry.SanguisQuestTypes;
import com.feliscape.sanguis.registry.SanguisTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class KillMobsQuest
extends HunterQuest {
    public static final MapCodec<KillMobsQuest> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("duration").forGetter(HunterQuest::getDuration), (App)Codec.BOOL.fieldOf("completed").forGetter(HunterQuest::isCompleted), (App)Codec.unboundedMap((Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec(), (Codec)Codec.INT).fieldOf("required_kills").forGetter(KillMobsQuest::getRequiredKills), (App)Codec.unboundedMap((Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec(), (Codec)Codec.INT).fieldOf("kills").forGetter(KillMobsQuest::getKills)).apply((Applicative)inst, KillMobsQuest::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, KillMobsQuest> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, HunterQuest::getDuration, (StreamCodec)ByteBufCodecs.BOOL, HunterQuest::isCompleted, (StreamCodec)ByteBufCodecs.map(Object2ObjectOpenHashMap::new, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE), (StreamCodec)ByteBufCodecs.VAR_INT), KillMobsQuest::getRequiredKills, (StreamCodec)ByteBufCodecs.map(Object2ObjectOpenHashMap::new, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE), (StreamCodec)ByteBufCodecs.VAR_INT), KillMobsQuest::getKills, (x$0, x$1, x$2, x$3) -> new KillMobsQuest((int)x$0, (boolean)x$1, (Map<EntityType<?>, Integer>)x$2, (Map)x$3));
    protected Map<EntityType<?>, Integer> requiredKills;
    protected HashMap<EntityType<?>, Integer> kills = new HashMap();

    public KillMobsQuest(Map<EntityType<?>, Integer> requiredKills) {
        this.requiredKills = requiredKills;
    }

    public KillMobsQuest(Map<EntityType<?>, Integer> requiredKills, Map<EntityType<?>, Integer> kills) {
        this.requiredKills = requiredKills;
        this.kills = new HashMap(kills);
    }

    public KillMobsQuest(int duration, boolean completed, Map<EntityType<?>, Integer> requiredKills, Map<EntityType<?>, Integer> kills) {
        super(duration, completed);
        this.requiredKills = requiredKills;
        this.kills = new HashMap(kills);
    }

    public QuestType<? extends KillMobsQuest> type() {
        return SanguisQuestTypes.KILL_MOBS.get();
    }

    @Override
    public boolean checkCompleted(Player player) {
        for (Map.Entry<EntityType<?>, Integer> entry : this.requiredKills.entrySet()) {
            if (!this.kills.containsKey(entry.getKey())) {
                return false;
            }
            if (this.kills.get(entry.getKey()) >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onComplete(Player player) {
    }

    @Override
    public Component getTypeName() {
        return Component.translatable((String)"quest.sanguis.kill_mobs.name").withStyle(ChatFormatting.GRAY);
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)"quest.sanguis.kill_mobs.title", (Object[])new Object[]{Component.translatable((String)((EntityType)((Map.Entry)this.requiredKills.entrySet().stream().findFirst().orElseThrow()).getKey()).getDescriptionId())}).withStyle(ChatFormatting.WHITE);
    }

    public Map<EntityType<?>, Integer> getRequiredKills() {
        return this.requiredKills;
    }

    public HashMap<EntityType<?>, Integer> getKills() {
        return this.kills;
    }

    public int getKills(EntityType<?> type) {
        return this.kills.get(type);
    }

    public void recordKill(EntityType<?> type) {
        this.recordKill(type, 1);
    }

    public void recordKill(EntityType<?> type, int amount) {
        if (!this.requiredKills.containsKey(type)) {
            return;
        }
        if (this.kills.containsKey(type)) {
            this.kills.put(type, this.kills.get(type) + amount);
        } else {
            this.kills.put(type, amount);
        }
        this.setDirty(true);
    }

    public static KillMobsQuest create(ServerLevel level) {
        HolderLookup.RegistryLookup typeLookup = level.getServer().registryAccess().lookupOrThrow(Registries.ENTITY_TYPE);
        HolderSet.Named availableTypes = typeLookup.getOrThrow(SanguisTags.EntityTypes.KILL_MOB_QUEST_VALID);
        return new KillMobsQuest(Map.of((EntityType)((Holder)availableTypes.getRandomElement(level.random).orElseThrow()).value(), Mth.nextInt((RandomSource)level.random, (int)10, (int)20)));
    }
}

