/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.quest;

import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.content.quest.registry.QuestType;
import com.feliscape.sanguis.registry.custom.SanguisRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;

public record QuestPredicate(Optional<HolderSet<QuestType<?>>> types, Optional<NbtPredicate> nbt) {
    public static final Codec<QuestPredicate> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RegistryCodecs.homogeneousList(SanguisRegistries.Keys.QUEST_TYPES).optionalFieldOf("types").forGetter(QuestPredicate::types), (App)NbtPredicate.CODEC.optionalFieldOf("nbt").forGetter(QuestPredicate::nbt)).apply((Applicative)inst, QuestPredicate::new));

    public boolean test(HunterQuest quest) {
        if (this.types.isEmpty() || quest.is(this.types.get())) {
            return true;
        }
        return this.nbt.isPresent() && this.nbt.get().matches(HunterQuest.serialize(quest));
    }

    public static class Builder {
        private Optional<HolderSet<QuestType<?>>> types = Optional.empty();
        private Optional<NbtPredicate> nbt = Optional.empty();

        public static Builder quest() {
            return new Builder();
        }

        public Builder of(QuestType<?> ... types) {
            this.types = Optional.of(HolderSet.direct(QuestType::builtInRegistryHolder, (Object[])types));
            return this;
        }

        public Builder of(Collection<QuestType<?>> blocks) {
            this.types = Optional.of(HolderSet.direct(QuestType::builtInRegistryHolder, blocks));
            return this;
        }

        public Builder of(TagKey<QuestType<?>> tag) {
            this.types = Optional.of(SanguisRegistries.QUEST_TYPES.getOrCreateTag(tag));
            return this;
        }

        public Builder hasNbt(CompoundTag nbt) {
            this.nbt = Optional.of(new NbtPredicate(nbt));
            return this;
        }

        public QuestPredicate build() {
            return new QuestPredicate(this.types, this.nbt);
        }
    }
}

