/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.advancement;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.data.datagen.advancement.SanguisAdvancements;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class CustomAdvancement {
    private final Advancement.Builder advancementBuilder;
    private final Builder builder;
    private final String id;
    AdvancementHolder datagenResult;
    private final Component title;
    private final Component description;

    public CustomAdvancement(String path, UnaryOperator<Builder> operator) {
        this.id = path;
        this.builder = Builder.of();
        operator.apply(this.builder);
        this.title = this.titleComponent(this.id, this.builder.type.titleColor);
        this.description = this.descriptionComponent(this.id);
        this.advancementBuilder = this.builder.builder;
        this.advancementBuilder.display(this.builder.displayIcon, this.title, this.description, this.builder.type.background, this.builder.type.border, this.builder.type.showToast, this.builder.announceToChatOverride.orElse(this.builder.type.announceToChat).booleanValue(), this.builder.hiddenOverride.orElse(this.builder.type.hidden).booleanValue());
        SanguisAdvancements.ENTRIES.add(this);
    }

    public String getId() {
        return this.id;
    }

    public Component getTitle() {
        return this.title;
    }

    public Component getDescription() {
        return this.description;
    }

    public void save(HolderLookup.Provider lookupProvider, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
        if (this.builder.parent != null) {
            this.builder.parent.ifLeft(a -> this.advancementBuilder.parent(a.datagenResult)).ifRight(a -> this.advancementBuilder.parent(a));
        }
        this.builder.resolveRegistryTriggers(lookupProvider);
        this.datagenResult = this.advancementBuilder.save(consumer, Sanguis.location(this.id), existingFileHelper);
    }

    private Component titleComponent(String name) {
        return Component.translatable((String)"advancements.%s.%s.title".formatted("sanguis", name.replace('/', '.')));
    }

    private Component titleComponent(String name, @Nullable ChatFormatting color) {
        MutableComponent mutable = Component.translatable((String)"advancements.%s.%s.title".formatted("sanguis", name.replace('/', '.')));
        if (color != null) {
            mutable.withStyle(color);
        }
        return mutable;
    }

    private Component descriptionComponent(String name) {
        return Component.translatable((String)"advancements.%s.%s.description".formatted("sanguis", name.replace('/', '.')));
    }

    public static class Builder {
        Either<CustomAdvancement, AdvancementHolder> parent;
        ItemStack displayIcon = ItemStack.EMPTY;
        Type type = Type.STANDARD;
        Optional<Boolean> announceToChatOverride = Optional.empty();
        Optional<Boolean> hiddenOverride = Optional.empty();
        Advancement.Builder builder;
        List<Function<HolderLookup.Provider, Criterion<?>>> registryTriggers = new ArrayList();
        private int keyIndex;

        public Builder() {
            this.builder = new Advancement.Builder();
        }

        public static Builder of() {
            return new Builder();
        }

        public Builder after(CustomAdvancement advancement) {
            this.parent = Either.left((Object)advancement);
            return this;
        }

        public Builder after(AdvancementHolder holder) {
            this.parent = Either.right((Object)holder);
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder icon(ItemLike item) {
            return this.icon(new ItemStack(item));
        }

        public Builder icon(ItemStack itemStack) {
            this.displayIcon = itemStack;
            return this;
        }

        public Builder announceToChat(boolean announceToChat) {
            this.announceToChatOverride = Optional.of(announceToChat);
            return this;
        }

        public Builder hidden(boolean hidden) {
            this.hiddenOverride = Optional.of(hidden);
            return this;
        }

        public Builder awardedAutomatically() {
            return this.trigger(PlayerTrigger.TriggerInstance.tick());
        }

        public Builder hasItem(ItemLike item) {
            return this.trigger(InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item}));
        }

        public Builder hasItem(ItemPredicate predicate) {
            return this.trigger(InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{predicate}));
        }

        public Builder hasItem(ItemPredicate ... predicates) {
            return this.trigger(InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])predicates));
        }

        public Builder hasItem(ItemLike ... items) {
            return this.trigger(InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
        }

        public Builder consumeItem(ItemLike item) {
            return this.trigger(ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)item.asItem()));
        }

        public Builder registryTrigger(Function<HolderLookup.Provider, Criterion<?>> trigger) {
            this.registryTriggers.add(trigger);
            return this;
        }

        public Builder trigger(Criterion<?> trigger) {
            this.builder.addCriterion(String.valueOf(this.keyIndex), trigger);
            ++this.keyIndex;
            return this;
        }

        public void resolveRegistryTriggers(HolderLookup.Provider registries) {
            for (Function<HolderLookup.Provider, Criterion<?>> t : this.registryTriggers) {
                this.trigger(t.apply(registries));
            }
        }
    }

    public static enum Type {
        ROOT(AdvancementType.TASK, true, false, false, Sanguis.location("textures/gui/advancements.png")),
        STANDARD(AdvancementType.TASK, false, true, false),
        GOAL(AdvancementType.GOAL, false, true, true),
        CHALLENGE(AdvancementType.CHALLENGE, false, true, true),
        HIDDEN(AdvancementType.TASK, true, true, false);

        public final AdvancementType border;
        public final boolean hidden;
        public final boolean showToast;
        public final boolean announceToChat;
        public final ResourceLocation background;
        @Nullable
        public final ChatFormatting titleColor;

        private Type(AdvancementType border, boolean hidden, boolean showToast, boolean announceToChat, ResourceLocation background) {
            this.border = border;
            this.hidden = hidden;
            this.showToast = showToast;
            this.announceToChat = announceToChat;
            this.background = background;
            this.titleColor = null;
        }

        private Type(AdvancementType border, boolean hidden, boolean showToast, boolean announceToChat) {
            this.border = border;
            this.hidden = hidden;
            this.showToast = showToast;
            this.announceToChat = announceToChat;
            this.background = null;
            this.titleColor = null;
        }

        private Type(AdvancementType border, boolean hidden, boolean showToast, boolean announceToChat, ChatFormatting titleColor) {
            this.border = border;
            this.hidden = hidden;
            this.showToast = showToast;
            this.announceToChat = announceToChat;
            this.background = null;
            this.titleColor = titleColor;
        }
    }
}

