/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.advancement;

import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.content.quest.QuestPredicate;
import com.feliscape.sanguis.content.quest.registry.QuestType;
import com.feliscape.sanguis.registry.SanguisCriteriaTriggers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class QuestCompletedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, HunterQuest quest) {
        super.trigger(player, triggerInstance -> triggerInstance.matches(quest));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, QuestPredicate quest) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)QuestPredicate.CODEC.fieldOf("quest").forGetter(TriggerInstance::quest)).apply((Applicative)inst, TriggerInstance::new));

        public static Criterion<TriggerInstance> questCompleted() {
            return TriggerInstance.questCompleted(QuestPredicate.Builder.quest().build());
        }

        public static Criterion<TriggerInstance> questCompleted(QuestType<?> type) {
            return TriggerInstance.questCompleted(QuestPredicate.Builder.quest().of(type).build());
        }

        public static Criterion<TriggerInstance> questCompleted(QuestType<?> ... types) {
            return TriggerInstance.questCompleted(QuestPredicate.Builder.quest().of(types).build());
        }

        public static Criterion<TriggerInstance> questCompleted(QuestPredicate questPredicate) {
            return SanguisCriteriaTriggers.QUEST_COMPLETED.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), questPredicate));
        }

        public boolean matches(HunterQuest quest) {
            return this.quest().test(quest);
        }
    }
}

