/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.datagen;

import com.feliscape.sanguis.data.datagen.SanguisGeneratedEntries;
import com.feliscape.sanguis.data.datagen.advancement.SanguisAdvancementProvider;
import com.feliscape.sanguis.data.datagen.language.SanguisEnUsProvider;
import com.feliscape.sanguis.data.datagen.loot.SanguisGlobalLootModifierProvider;
import com.feliscape.sanguis.data.datagen.loot.SanguisLootTableProvider;
import com.feliscape.sanguis.data.datagen.map.SanguisDataMapProvider;
import com.feliscape.sanguis.data.datagen.model.SanguisBlockModelProvider;
import com.feliscape.sanguis.data.datagen.model.SanguisItemModelProvider;
import com.feliscape.sanguis.data.datagen.recipe.SanguisRecipeProvider;
import com.feliscape.sanguis.data.datagen.tag.SanguisBiomeTagGenerator;
import com.feliscape.sanguis.data.datagen.tag.SanguisBlockTagGenerator;
import com.feliscape.sanguis.data.datagen.tag.SanguisDamageTypeTagGenerator;
import com.feliscape.sanguis.data.datagen.tag.SanguisEntityTypeTagGenerator;
import com.feliscape.sanguis.data.datagen.tag.SanguisItemTagGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="sanguis")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherClientData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        SanguisGeneratedEntries generatedEntries = new SanguisGeneratedEntries(packOutput, lookupProvider);
        lookupProvider = generatedEntries.getRegistryProvider();
        generator.addProvider(true, (DataProvider)generatedEntries);
        generator.addProvider(true, (DataProvider)new SanguisRecipeProvider(packOutput, lookupProvider));
        SanguisBlockTagGenerator blockTags = new SanguisBlockTagGenerator(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(true, (DataProvider)blockTags);
        generator.addProvider(true, (DataProvider)new SanguisItemTagGenerator(packOutput, lookupProvider, existingFileHelper, blockTags.contentsGetter()));
        generator.addProvider(true, (DataProvider)new SanguisEntityTypeTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(true, (DataProvider)new SanguisBiomeTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(true, (DataProvider)new SanguisDamageTypeTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(true, (DataProvider)new SanguisDataMapProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new SanguisLootTableProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new SanguisGlobalLootModifierProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new SanguisAdvancementProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(true, (DataProvider)new SanguisBlockModelProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new SanguisItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new SanguisEnUsProvider(packOutput));
    }
}

