/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.datagen.advancement;

import com.feliscape.sanguis.data.advancement.CustomAdvancement;
import com.feliscape.sanguis.data.advancement.QuestCompletedTrigger;
import com.feliscape.sanguis.data.advancement.SimpleEventTrigger;
import com.feliscape.sanguis.registry.SanguisBlocks;
import com.feliscape.sanguis.registry.SanguisItems;
import com.feliscape.sanguis.registry.SanguisTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class SanguisAdvancements
implements AdvancementProvider.AdvancementGenerator {
    public static final List<CustomAdvancement> ENTRIES = new ArrayList<CustomAdvancement>();
    public static final CustomAdvancement ROOT = SanguisAdvancements.create("sanguis/root", b -> b.icon((ItemLike)SanguisItems.DAEMONOLOGIE).type(CustomAdvancement.Type.ROOT).awardedAutomatically());
    public static final CustomAdvancement VAMPIRE_TRANSFORMATION = SanguisAdvancements.create("sanguis/vampire/transformation", b -> b.icon((ItemLike)SanguisItems.BLOODY_FANG).after(ROOT).type(CustomAdvancement.Type.STANDARD).trigger(SimpleEventTrigger.TriggerInstance.vampireTransformation()));
    public static final CustomAdvancement BAT_TRANSFORM = SanguisAdvancements.create("sanguis/vampire/bat_transform", b -> b.icon((ItemLike)SanguisItems.BAT_WING).after(VAMPIRE_TRANSFORMATION).type(CustomAdvancement.Type.STANDARD).trigger(SimpleEventTrigger.TriggerInstance.batTransform()));
    public static final CustomAdvancement VAMPIRE_CURE = SanguisAdvancements.create("sanguis/vampire/cure", b -> b.icon((ItemLike)SanguisItems.GARLIC_INJECTION).after(VAMPIRE_TRANSFORMATION).type(CustomAdvancement.Type.STANDARD).trigger(SimpleEventTrigger.TriggerInstance.vampireCure()));
    public static final CustomAdvancement HUNTER_INJECT = SanguisAdvancements.create("sanguis/hunter/inject", b -> b.icon((ItemLike)SanguisItems.GARLIC).after(ROOT).type(CustomAdvancement.Type.STANDARD).trigger(SimpleEventTrigger.TriggerInstance.hunterInject()));
    public static final CustomAdvancement QUEST_COMPLETE = SanguisAdvancements.create("quest_complete", b -> b.icon((ItemLike)SanguisBlocks.QUEST_BOARD).after(HUNTER_INJECT).type(CustomAdvancement.Type.STANDARD).trigger(QuestCompletedTrigger.TriggerInstance.questCompleted()));
    public static final CustomAdvancement BIBLE_HIT = SanguisAdvancements.create("bible_hit", b -> b.icon((ItemLike)SanguisItems.DAEMONOLOGIE).after(ROOT).type(CustomAdvancement.Type.STANDARD).hidden(true).trigger(SanguisAdvancements.hitWith(SanguisItems.DAEMONOLOGIE, EntityPredicate.Builder.entity().of(SanguisTags.EntityTypes.VAMPIRIC).build())));
    public static final CustomAdvancement END = null;

    protected static Criterion<?> hitWith(ItemLike itemLike, EntityPredicate entity) {
        return PlayerHurtEntityTrigger.TriggerInstance.playerHurtEntity((DamagePredicate.Builder)DamagePredicate.Builder.damageInstance().sourceEntity(EntityPredicate.Builder.entity().equipment(EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().of(new ItemLike[]{itemLike}))).build()), Optional.of(entity));
    }

    private static CustomAdvancement create(String id, UnaryOperator<CustomAdvancement.Builder> b) {
        return new CustomAdvancement(id, b);
    }

    public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
        for (CustomAdvancement advancement : ENTRIES) {
            advancement.save(provider, consumer, existingFileHelper);
        }
    }

    private static AdvancementHolder placeholder(String id) {
        return AdvancementSubProvider.createPlaceholder((String)id);
    }
}

