/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.datagen.language;

import com.feliscape.sanguis.data.advancement.CustomAdvancement;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.neoforged.jarjar.nio.util.Lazy;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.data.LanguageProvider;

public abstract class SanguisLanguageProvider
extends LanguageProvider {
    public SanguisLanguageProvider(PackOutput output, String locale) {
        super(output, "sanguis", locale);
    }

    protected void addBlockAndItem(Supplier<? extends Block> key, String name) {
        this.addBlock(key, name);
        this.addItem(() -> ((Block)key.get()).asItem(), name);
    }

    protected void addItemTooltip(Supplier<? extends Item> key, String name) {
        this.add(key.get().getDescriptionId() + ".tooltip", name);
    }

    protected void addDeathMessage(ResourceKey<DamageType> key, String message) {
        this.add("death.attack.%s".formatted(key.location().toString()), message);
    }

    protected void addDeathMessageItem(ResourceKey<DamageType> key, String message) {
        this.add("death.attack.%s.item".formatted(key.location().toString()), message);
    }

    protected void addDeathMessagePlayer(ResourceKey<DamageType> key, String message) {
        this.add("death.attack.%s.player".formatted(key.location().toString()), message);
    }

    protected void addMobEffect(Holder<? extends MobEffect> key, String name) {
        this.add(((MobEffect)key.value()).getDescriptionId(), name);
    }

    protected void addSubtitle(Supplier<SoundEvent> key, String name) {
        this.add("subtitle.%s.%s".formatted("sanguis", key.get().getLocation().getPath()), name);
    }

    protected void addAdvancement(String id, String title, String description) {
        this.add("advancements.%s.%s.title".formatted("sanguis", id), title);
        this.add("advancements.%s.%s.description".formatted("sanguis", id), description);
    }

    protected void addAdvancement(CustomAdvancement advancement, String title, String description) {
        TranslatableContents translatable;
        ComponentContents componentContents = advancement.getTitle().getContents();
        if (componentContents instanceof TranslatableContents) {
            translatable = (TranslatableContents)componentContents;
            this.add(translatable.getKey(), title);
        }
        if ((componentContents = advancement.getDescription().getContents()) instanceof TranslatableContents) {
            translatable = (TranslatableContents)componentContents;
            this.add(translatable.getKey(), description);
        }
    }

    protected void addEnchantment(ResourceKey<Enchantment> key, String name) {
        this.add(Util.makeDescriptionId((String)"enchantment", (ResourceLocation)key.location()), name);
    }

    protected void addBiome(ResourceKey<Biome> key, String name) {
        this.add(Util.makeDescriptionId((String)"biome", (ResourceLocation)key.location()), name);
    }

    protected void addTab(Supplier<CreativeModeTab> key, String name) {
        this.add(Util.makeDescriptionId((String)"itemGroup", (ResourceLocation)BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)key.get())), name);
    }

    protected void addKeyMapping(KeyMapping mapping, String name) {
        this.add(mapping.getName(), name);
    }

    protected void addKeyMapping(Lazy<KeyMapping> mapping, String name) {
        this.add(((KeyMapping)mapping.get()).getName(), name);
    }

    protected void addConfigSection(String section, String name) {
        this.add("sanguis.configuration." + section, name);
    }

    protected void addConfigValue(String id, String name) {
        this.add("sanguis.configuration." + id, name);
    }

    protected void addConfigValue(String environment, ModConfigSpec.ConfigValue<?> value, String name) {
        this.add("%s.configuration.%s.%s".formatted("sanguis", environment, this.combineConfigValuePath(value.getPath())), name);
    }

    protected String combineConfigValuePath(List<String> path) {
        StringBuilder string = new StringBuilder();
        for (int i = 0; i < path.size(); ++i) {
            string.append(path.get(i));
            if (i >= path.size() - 1) continue;
            string.append(".");
        }
        return string.toString();
    }
}

