/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.datagen.loot;

import com.feliscape.sanguis.content.block.BloodOrangeLeavesBlock;
import com.feliscape.sanguis.content.block.CoffinBlock;
import com.feliscape.sanguis.content.block.GarlicCropBlock;
import com.feliscape.sanguis.registry.SanguisBlocks;
import com.feliscape.sanguis.registry.SanguisItems;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class SanguisBlockLootTableProvider
extends BlockLootSubProvider {
    protected SanguisBlockLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        HolderLookup.RegistryLookup enchantmentLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.dropOther((Block)SanguisBlocks.QUEST_BOARD.get(), (ItemLike)Blocks.STRIPPED_OAK_LOG);
        this.dropSelf((Block)SanguisBlocks.GARLIC_STRING.get());
        this.add((Block)SanguisBlocks.BLOOD_ORANGE_VINE.get(), this::createBloodOrangeVineTable);
        this.add((Block)SanguisBlocks.BLOOD_ORANGE_LEAVES.get(), this::createBloodOrangeLeavesTable);
        this.add((Block)SanguisBlocks.WHITE_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.LIGHT_GRAY_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.GRAY_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.BLACK_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.BROWN_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.RED_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.ORANGE_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.YELLOW_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.LIME_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.GREEN_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.CYAN_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.LIGHT_BLUE_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.BLUE_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.PURPLE_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.MAGENTA_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.PINK_COFFIN.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)CoffinBlock.PART, (Comparable)BedPart.HEAD));
        this.add((Block)SanguisBlocks.WILD_GARLIC.get(), block -> this.createWildCropDrops((Block)block, (ItemLike)SanguisItems.GARLIC));
        LootItemBlockStatePropertyCondition.Builder garlicAgeCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)SanguisBlocks.GARLIC.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)GarlicCropBlock.AGE, 4));
        this.add((Block)SanguisBlocks.GARLIC.get(), arg_0 -> this.lambda$generate$17((LootItemCondition.Builder)garlicAgeCondition, enchantmentLookup, arg_0));
    }

    private LootTable.Builder createBloodOrangeLeavesTable(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(SanguisItems.BLOOD_ORANGE)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BloodOrangeLeavesBlock.ORANGES, true)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)SanguisItems.BLOOD_ORANGE_SEEDS.get())).when(LootItemRandomChanceCondition.randomChance((float)0.25f)))));
    }

    private LootTable.Builder createBloodOrangeVineTable(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.15f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(SanguisItems.BLOOD_ORANGE_SEEDS)));
    }

    private LootTable.Builder createWildCropDrops(Block block, ItemLike drop) {
        return this.createShearsDispatchTable(block, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)drop).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return SanguisBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }

    private /* synthetic */ LootTable.Builder lambda$generate$17(LootItemCondition.Builder garlicAgeCondition, HolderLookup.RegistryLookup enchantmentLookup, Block block) {
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(SanguisItems.GARLIC))).withPool(LootPool.lootPool().when(garlicAgeCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(SanguisItems.GARLIC).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)enchantmentLookup.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3)))).withPool(LootPool.lootPool().when(garlicAgeCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(SanguisItems.GARLIC_FLOWER).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)enchantmentLookup.getOrThrow(Enchantments.FORTUNE), (float)0.4f, (int)2)))));
    }
}

