/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.datagen.loot;

import com.feliscape.sanguis.registry.SanguisEntityTypes;
import com.feliscape.sanguis.registry.SanguisItems;
import com.feliscape.sanguis.registry.SanguisTags;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class SanguisEntityLootTableProvider
extends EntityLootSubProvider {
    private static final Set<EntityType<?>> SPECIAL_LOOT_TABLE_TYPES = ImmutableSet.of();
    private static final LootItemCondition.Builder KILLED_WITH_STAKE = SanguisEntityLootTableProvider.killedWith(SanguisTags.Items.STAKES);

    public SanguisEntityLootTableProvider(HolderLookup.Provider registries) {
        super(FeatureFlags.REGISTRY.allFlags(), registries);
    }

    public void generate() {
        this.add((EntityType)SanguisEntityTypes.VAMPIRE_HUNTER.get(), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EMERALD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).when(LootItemRandomChanceCondition.randomChance((float)0.7f))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(SanguisItems.GARLIC).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.3f, (float)4.0f)))).when(LootItemRandomChanceCondition.randomChance((float)0.5f))));
        this.add((EntityType)SanguisEntityTypes.VAMPIRE.get(), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(SanguisItems.BLOODY_FANG).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).withPool(LootPool.lootPool().add(LootItem.lootTableItem(SanguisItems.VAMPIRE_BLOOD).when(KILLED_WITH_STAKE))));
    }

    protected boolean canHaveLootTable(EntityType<?> type) {
        return super.canHaveLootTable(type) || SPECIAL_LOOT_TABLE_TYPES.contains(type);
    }

    protected Stream<EntityType<?>> getKnownEntityTypes() {
        return SanguisEntityTypes.ENTITY_TYPES.getEntries().stream().map(Supplier::get);
    }

    private static LootItemCondition.Builder killedWith(ItemLike item) {
        return LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().equipment(EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().of(new ItemLike[]{item}))));
    }

    private static LootItemCondition.Builder killedWith(TagKey<Item> item) {
        return LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().equipment(EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().of(item))));
    }
}

