/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.datagen.model;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.content.block.BloodOrangeLeavesBlock;
import com.feliscape.sanguis.content.block.BloodOrangeVineBlock;
import com.feliscape.sanguis.content.block.CoffinBlock;
import com.feliscape.sanguis.registry.SanguisBlocks;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class SanguisBlockModelProvider
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public SanguisBlockModelProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "sanguis", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlockWithItem((Block)SanguisBlocks.QUEST_BOARD.get(), (ModelFile)this.models().cubeColumn(this.name((Block)SanguisBlocks.QUEST_BOARD.get()), this.blockTexture((Block)SanguisBlocks.QUEST_BOARD.get()).withSuffix("_side"), ResourceLocation.withDefaultNamespace((String)"block/stripped_oak_log_top")));
        this.simpleCropBlock((CropBlock)SanguisBlocks.GARLIC.get());
        this.crossBlockWithRenderType((Block)SanguisBlocks.WILD_GARLIC.get(), "cutout");
        this.simpleBlock((Block)SanguisBlocks.GARLIC_STRING.get(), (ModelFile)this.models().getExistingFile(Sanguis.location("block/garlic_string")));
        this.bloodOrangeVineBlock((BloodOrangeVineBlock)((Object)SanguisBlocks.BLOOD_ORANGE_VINE.get()));
        this.bloodOrangeLeavesBlock((BloodOrangeLeavesBlock)((Object)SanguisBlocks.BLOOD_ORANGE_LEAVES.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.WHITE_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.LIGHT_GRAY_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.GRAY_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.BLACK_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.BROWN_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.RED_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.ORANGE_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.YELLOW_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.LIME_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.GREEN_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.CYAN_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.LIGHT_BLUE_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.BLUE_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.PURPLE_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.MAGENTA_COFFIN.get()));
        this.coffin((CoffinBlock)((Object)SanguisBlocks.PINK_COFFIN.get()));
    }

    private void bloodOrangeLeavesBlock(BloodOrangeLeavesBlock block) {
        ResourceLocation vineEndTexture = Sanguis.location("block/blood_orange_vine_head");
        ModelBuilder normal = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), Sanguis.location("block/template_blood_orange_leaves"))).texture("all", this.blockTexture(block))).texture("vine", vineEndTexture);
        ModelBuilder oranges = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_oranges", Sanguis.location("block/template_blood_orange_leaves"))).texture("all", this.blockTexture(block).withSuffix("_oranges"))).texture("vine", vineEndTexture);
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> SanguisBlockModelProvider.lambda$bloodOrangeLeavesBlock$0((ModelFile)oranges, (ModelFile)normal, arg_0), new Property[]{BloodOrangeLeavesBlock.WATERLOGGED});
    }

    private void bloodOrangeVineBlock(BloodOrangeVineBlock block) {
        ModelBuilder body = ((BlockModelBuilder)this.models().cross(this.name(block) + "_body", this.blockTexture(block).withSuffix("_body"))).renderType("cutout");
        ModelBuilder head = ((BlockModelBuilder)this.models().cross(this.name(block) + "_head", this.blockTexture(block).withSuffix("_head"))).renderType("cutout");
        this.getVariantBuilder(block).forAllStates(arg_0 -> SanguisBlockModelProvider.lambda$bloodOrangeVineBlock$1((ModelFile)head, (ModelFile)body, arg_0));
    }

    private void coffin(CoffinBlock block) {
        DyeColor color = block.getColor();
        ResourceLocation velvetLocation = Sanguis.location("block/" + color.getName() + "_velvet");
        ModelBuilder head = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block) + "_head", Sanguis.location("block/template_coffin_head"))).texture("velvet", velvetLocation);
        ModelBuilder foot = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block) + "_foot", Sanguis.location("block/template_coffin_foot"))).texture("velvet", velvetLocation);
        ModelBuilder headSealed = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block) + "_head_sealed", Sanguis.location("block/template_coffin_head_sealed"))).texture("velvet", velvetLocation);
        ModelBuilder footSealed = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block) + "_foot_sealed", Sanguis.location("block/template_coffin_foot_sealed"))).texture("velvet", velvetLocation);
        ModelBuilder inventory = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block) + "_inventory", Sanguis.location("block/template_coffin_inventory"))).texture("velvet", velvetLocation);
        this.simpleBlockItem((Block)block, (ModelFile)inventory);
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> SanguisBlockModelProvider.lambda$coffin$2((ModelFile)headSealed, (ModelFile)footSealed, (ModelFile)head, (ModelFile)foot, arg_0), new Property[0]);
    }

    private void simpleCropBlock(CropBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            int age = block.getAge(state);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().crop(this.name((Block)block) + "_" + age, this.extend(this.blockTexture((Block)block), "_" + age))).renderType("cutout")).build();
        });
    }

    private void blockWithItem(Supplier<? extends Block> block) {
        this.simpleBlockWithItem(block.get(), this.cubeAll(block.get()));
    }

    private void blockWithItem(Supplier<? extends Block> block, String renderType) {
        this.simpleBlockWithItem(block.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(block.get()), this.blockTexture(block.get()))).renderType(renderType));
    }

    private void leavesBlock(Supplier<? extends Block> block, String renderType) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getLocation(block).getPath(), "minecraft:block/leaves")).texture("all", this.blockTexture(block.get()))).renderType(renderType);
        this.getVariantBuilder(block.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        this.simpleBlockItem(block.get(), (ModelFile)model);
    }

    public void crossBlockWithRenderType(Block block, String renderType) {
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().cross(this.name(block), this.blockTexture(block))).renderType(renderType))});
    }

    private String name(Block block) {
        return this.getLocation(block).getPath();
    }

    private ResourceLocation getLocation(Supplier<? extends Block> block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block.get());
    }

    private ResourceLocation getLocation(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private ResourceLocation extend(ResourceLocation location, String suffix) {
        String namespace = location.getNamespace();
        String path = location.getPath();
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(path + suffix));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$coffin$2(ModelFile headSealed, ModelFile footSealed, ModelFile head, ModelFile foot, BlockState state) {
        BedPart part = (BedPart)state.getValue(CoffinBlock.PART);
        Direction rotation = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        Boolean sealed = (Boolean)state.getValue((Property)CoffinBlock.OCCUPIED);
        return ConfiguredModel.builder().modelFile(sealed.booleanValue() ? (part == BedPart.HEAD ? headSealed : footSealed) : (part == BedPart.HEAD ? head : foot)).rotationY((int)rotation.toYRot() + 180).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$bloodOrangeVineBlock$1(ModelFile head, ModelFile body, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.getValue((Property)BloodOrangeVineBlock.HEAD) != false ? head : body).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$bloodOrangeLeavesBlock$0(ModelFile oranges, ModelFile normal, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.getValue((Property)BloodOrangeLeavesBlock.ORANGES) != false ? oranges : normal).build();
    }
}

