/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.datagen.model;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.client.SanguisItemProperties;
import com.feliscape.sanguis.registry.SanguisBlocks;
import com.feliscape.sanguis.registry.SanguisDataComponents;
import com.feliscape.sanguis.registry.SanguisItems;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class SanguisItemModelProvider
extends ItemModelProvider {
    public SanguisItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "sanguis", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem((Supplier<? extends Item>)SanguisItems.DAEMONOLOGIE);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.BAT_WING);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.BLOODY_FANG);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.VAMPIRE_BLOOD);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.ACTIVATED_VAMPIRE_BLOOD);
        this.bloodBottleItem((Supplier<? extends Item>)SanguisItems.BLOOD_BOTTLE);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.BLOOD_ORANGE);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.BLOOD_ORANGE_SEEDS);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.BLOOD_SOAKED_COIN);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.BLACKENED_COIN);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.STEEL_BLEND);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.STEEL_INGOT);
        this.syringeItem((Supplier<? extends Item>)SanguisItems.SYRINGE);
        this.syringeItem((Supplier<? extends Item>)SanguisItems.BLOOD_SYRINGE);
        this.syringeItem((Supplier<? extends Item>)SanguisItems.GARLIC_INJECTION);
        this.syringeItem((Supplier<? extends Item>)SanguisItems.ACID_INJECTION);
        this.handheldItem((Supplier<? extends Item>)SanguisItems.WOODEN_STAKE);
        this.handheldItem((Supplier<? extends Item>)SanguisItems.REINFORCED_STAKE);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.GOLDEN_QUARREL);
        this.generatedBlockItem((Supplier<? extends Block>)SanguisBlocks.WILD_GARLIC);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.GARLIC);
        this.simpleItem((Supplier<? extends Item>)SanguisItems.GARLIC_FLOWER);
        this.spawnEggItem((Item)SanguisItems.VAMPIRE_SPAWN_EGG.get());
        this.spawnEggItem((Item)SanguisItems.VAMPIRE_HUNTER_SPAWN_EGG.get());
        this.blockItemSprite((Supplier<? extends Block>)SanguisBlocks.GARLIC_STRING);
    }

    private ItemModelBuilder bloodBottleItem(Supplier<? extends Item> item) {
        int maxBlood = (Integer)item.get().getDefaultInstance().getOrDefault(SanguisDataComponents.MAX_BLOOD, (Object)0);
        if (maxBlood == 0) {
            throw new IllegalArgumentException("Item %s has no default sanguis:max_blood component".formatted(this.getLocation(item)));
        }
        ItemModelBuilder builder = this.simpleItem(item);
        for (int i = 1; i <= maxBlood; ++i) {
            ResourceLocation location = this.getLocation(item).withSuffix("_" + i);
            this.simpleItem(location);
            builder.override().predicate(SanguisItemProperties.BLOOD, (float)i / (float)maxBlood).model((ModelFile)new ModelFile.UncheckedModelFile(location.withPrefix("item/"))).end();
        }
        return builder;
    }

    private ItemModelBuilder syringeItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.getLocation(item.get()).getPath(), Sanguis.location("item/template_syringe"))).texture("layer0", Sanguis.location("item/" + this.getLocation(item.get()).getPath()));
    }

    private ItemModelBuilder simpleItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.getLocation(item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", Sanguis.location("item/" + this.getLocation(item.get()).getPath()));
    }

    private ItemModelBuilder simpleItem(ResourceLocation item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.toString(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)item.getNamespace(), (String)("item/" + item.getPath())));
    }

    private ItemModelBuilder simpleDoubleLayered(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.getLocation(item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", Sanguis.location("item/" + this.getLocation(item.get()).getPath()))).texture("layer1", Sanguis.location("item/" + this.getLocation(item.get()).getPath() + "_overlay"));
    }

    private ItemModelBuilder handheldItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.getLocation(item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/handheld"))).texture("layer0", Sanguis.location("item/" + this.getLocation(item.get()).getPath()));
    }

    private ItemModelBuilder rotatedHandheldItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.getLocation(item.get()).getPath(), Sanguis.location("item/rotated_handheld"))).texture("layer0", Sanguis.location("item/" + this.getLocation(item.get()).getPath()));
    }

    private ItemModelBuilder itemWithBlockTexture(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.getLocation(item.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", Sanguis.location("block/" + this.getLocation(item.get()).getPath()));
    }

    public void manualBlockItem(Supplier<? extends Block> block) {
        this.withExistingParent("sanguis:" + BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath(), this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath()));
    }

    public void trapdoorItem(Supplier<? extends Block> block) {
        this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath(), this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath() + "_bottom"));
    }

    public void fenceItem(Supplier<? extends Block> block, Supplier<? extends Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", Sanguis.location("block/" + BuiltInRegistries.BLOCK.getKey((Object)baseBlock.get()).getPath()));
    }

    public void buttonItem(Supplier<? extends Block> block, Supplier<? extends Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath(), this.mcLoc("block/button_inventory"))).texture("texture", Sanguis.location("block/" + BuiltInRegistries.BLOCK.getKey((Object)baseBlock.get()).getPath()));
    }

    public void wallItem(Supplier<? extends Block> block, Supplier<? extends Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", Sanguis.location("block/" + BuiltInRegistries.BLOCK.getKey((Object)baseBlock.get()).getPath()));
    }

    public void minecraftBasedWallItem(Supplier<? extends Block> block, Block baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.withDefaultNamespace((String)("block/" + BuiltInRegistries.BLOCK.getKey((Object)baseBlock).getPath())));
    }

    private ItemModelBuilder blockItemSprite(Supplier<? extends Block> block) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.getBlockLocation(block.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", Sanguis.location("item/" + this.getBlockLocation(block.get()).getPath()));
    }

    private ItemModelBuilder blockItemSprite(Supplier<? extends Block> block, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.getBlockLocation(block.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", texture);
    }

    private ItemModelBuilder blockItemSpriteLayered(Supplier<? extends Block> block) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.getBlockLocation(block.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", Sanguis.location("item/" + this.getBlockLocation(block.get()).getPath()))).texture("layer1", String.valueOf(Sanguis.location("item/" + this.getBlockLocation(block.get()).getPath())) + "_overlay");
    }

    private ItemModelBuilder generatedBlockItem(Supplier<? extends Block> block) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.getBlockLocation(block.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", Sanguis.location("block/" + this.getBlockLocation(block.get()).getPath()));
    }

    private ItemModelBuilder generatedBlockItem(Supplier<? extends Block> block, ResourceLocation sprite) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.getBlockLocation(block.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", sprite);
    }

    private ResourceLocation getLocation(Supplier<? extends Item> item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.get());
    }

    private ResourceLocation getLocation(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    private ResourceLocation getBlockLocation(Supplier<? extends Block> block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block.get());
    }

    private ResourceLocation getBlockLocation(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private ResourceLocation blockTexture(Supplier<? extends Block> block) {
        ResourceLocation location = this.getBlockLocation(block);
        return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("block/" + location.getPath()));
    }

    private ResourceLocation blockTexture(Block block) {
        ResourceLocation location = this.getBlockLocation(block);
        return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("block/" + location.getPath()));
    }

    private ResourceLocation getBlockItemSpriteLocation(Supplier<? extends Block> block) {
        return Sanguis.location("item/" + this.getBlockLocation(block.get()).getPath());
    }
}

