/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.datagen.recipe;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.content.block.CoffinBlock;
import com.feliscape.sanguis.content.item.BloodBottleItem;
import com.feliscape.sanguis.data.recipe.BloodBottleIngredient;
import com.feliscape.sanguis.registry.SanguisBlocks;
import com.feliscape.sanguis.registry.SanguisItems;
import com.feliscape.sanguis.registry.SanguisTags;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.registries.DeferredItem;

public class SanguisRecipeProvider
extends RecipeProvider {
    public static final ICustomIngredient NON_EMPTY_BLOOD_BOTTLE_INGREDIENT = BloodBottleIngredient.of();
    private static final Map<DyeColor, Item> WOOL_FROM_COLOR = ImmutableMap.builder().put((Object)DyeColor.BLACK, (Object)Items.BLACK_WOOL).put((Object)DyeColor.BLUE, (Object)Items.BLUE_WOOL).put((Object)DyeColor.BROWN, (Object)Items.BROWN_WOOL).put((Object)DyeColor.CYAN, (Object)Items.CYAN_WOOL).put((Object)DyeColor.GRAY, (Object)Items.GRAY_WOOL).put((Object)DyeColor.GREEN, (Object)Items.GREEN_WOOL).put((Object)DyeColor.LIGHT_BLUE, (Object)Items.LIGHT_BLUE_WOOL).put((Object)DyeColor.LIGHT_GRAY, (Object)Items.LIGHT_GRAY_WOOL).put((Object)DyeColor.LIME, (Object)Items.LIME_WOOL).put((Object)DyeColor.MAGENTA, (Object)Items.MAGENTA_WOOL).put((Object)DyeColor.ORANGE, (Object)Items.ORANGE_WOOL).put((Object)DyeColor.PINK, (Object)Items.PINK_WOOL).put((Object)DyeColor.PURPLE, (Object)Items.PURPLE_WOOL).put((Object)DyeColor.RED, (Object)Items.RED_WOOL).put((Object)DyeColor.YELLOW, (Object)Items.YELLOW_WOOL).put((Object)DyeColor.WHITE, (Object)Items.WHITE_WOOL).build();

    public SanguisRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        List<Item> dyes = List.of(Items.WHITE_DYE, Items.LIGHT_GRAY_DYE, Items.GRAY_DYE, Items.BLACK_DYE, Items.BROWN_DYE, Items.RED_DYE, Items.ORANGE_DYE, Items.YELLOW_DYE, Items.LIME_DYE, Items.GREEN_DYE, Items.CYAN_DYE, Items.LIGHT_BLUE_DYE, Items.BLUE_DYE, Items.PURPLE_DYE, Items.MAGENTA_DYE, Items.PINK_DYE);
        List<Item> coffins = List.of(SanguisBlocks.WHITE_COFFIN.asItem(), SanguisBlocks.LIGHT_GRAY_COFFIN.asItem(), SanguisBlocks.GRAY_COFFIN.asItem(), SanguisBlocks.BLACK_COFFIN.asItem(), SanguisBlocks.BROWN_COFFIN.asItem(), SanguisBlocks.RED_COFFIN.asItem(), SanguisBlocks.ORANGE_COFFIN.asItem(), SanguisBlocks.YELLOW_COFFIN.asItem(), SanguisBlocks.LIME_COFFIN.asItem(), SanguisBlocks.GREEN_COFFIN.asItem(), SanguisBlocks.CYAN_COFFIN.asItem(), SanguisBlocks.LIGHT_BLUE_COFFIN.asItem(), SanguisBlocks.BLUE_COFFIN.asItem(), SanguisBlocks.PURPLE_COFFIN.asItem(), SanguisBlocks.MAGENTA_COFFIN.asItem(), SanguisBlocks.PINK_COFFIN.asItem());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)SanguisItems.WOODEN_STAKE.get())).pattern("/").pattern("#").pattern("#").define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).define(Character.valueOf('#'), ItemTags.PLANKS).unlockedBy("has_planks", SanguisRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)SanguisItems.REINFORCED_STAKE.get())).pattern("/").pattern("S").pattern("#").define(Character.valueOf('S'), SanguisItems.STEEL_INGOT).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).define(Character.valueOf('#'), ItemTags.PLANKS).unlockedBy("has_planks", SanguisRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)SanguisItems.GOLDEN_QUARREL.get())).pattern("#").pattern("/").pattern("F").define(Character.valueOf('#'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), (ItemLike)Items.FEATHER).unlockedBy("has_gold_nugget", SanguisRecipeProvider.has((ItemLike)Items.GOLD_NUGGET)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SanguisItems.SYRINGE).pattern("#").pattern("#").pattern("I").define(Character.valueOf('#'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('I'), (ItemLike)Items.IRON_NUGGET).unlockedBy(SanguisRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), SanguisRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, SanguisItems.GARLIC_INJECTION).requires(SanguisItems.SYRINGE).requires(SanguisItems.GARLIC, 3).requires((ItemLike)Items.GOLDEN_APPLE).unlockedBy(SanguisRecipeProvider.getHasName(SanguisItems.SYRINGE), SanguisRecipeProvider.has(SanguisItems.SYRINGE)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, SanguisItems.ACID_INJECTION).requires(SanguisItems.SYRINGE).requires((ItemLike)Items.APPLE, 2).requires((ItemLike)Items.SLIME_BALL).requires(SanguisItems.VAMPIRE_BLOOD).unlockedBy(SanguisRecipeProvider.getHasName(SanguisItems.SYRINGE), SanguisRecipeProvider.has(SanguisItems.SYRINGE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)BloodBottleItem.getWithFill(0)).pattern("# #").pattern("I#I").define(Character.valueOf('#'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('I'), (ItemLike)Items.IRON_NUGGET).unlockedBy(SanguisRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), SanguisRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SanguisBlocks.GARLIC_STRING, (int)4).pattern("GSG").pattern("GSG").pattern("GSG").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('G'), SanguisItems.GARLIC_FLOWER).unlockedBy(SanguisRecipeProvider.getHasName(SanguisItems.GARLIC_FLOWER), SanguisRecipeProvider.has(SanguisItems.GARLIC_FLOWER)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SanguisItems.BLOOD_SOAKED_COIN).pattern("WGW").pattern(" B ").define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('W'), SanguisItems.BAT_WING).define(Character.valueOf('B'), NON_EMPTY_BLOOD_BOTTLE_INGREDIENT.toVanilla()).unlockedBy(SanguisRecipeProvider.getHasName(SanguisItems.BAT_WING), SanguisRecipeProvider.has(SanguisItems.BAT_WING)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, SanguisItems.PARASOL).pattern("###").pattern("B/B").pattern(" / ").define(Character.valueOf('/'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('#'), (ItemLike)Blocks.BLACK_WOOL).define(Character.valueOf('B'), SanguisItems.BAT_WING).unlockedBy(SanguisRecipeProvider.getHasName((ItemLike)Blocks.BLACK_WOOL), SanguisRecipeProvider.has((ItemLike)Blocks.BLACK_WOOL)).save(recipeOutput);
        SanguisRecipeProvider.oneToOneConversionRecipe((RecipeOutput)recipeOutput, SanguisItems.BLOOD_ORANGE_SEEDS, SanguisItems.BLOOD_ORANGE, null);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, SanguisItems.STEEL_BLEND).requires((ItemLike)Items.IRON_INGOT, 2).requires(ItemTags.COALS).requires(SanguisItems.GARLIC).unlockedBy(SanguisRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), SanguisRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, SanguisItems.DAEMONOLOGIE).requires(SanguisTags.Items.GUIDE_BOOK_MATERIALS).requires((ItemLike)Items.BOOK).unlockedBy("has_guide_book_material", SanguisRecipeProvider.has(SanguisTags.Items.GUIDE_BOOK_MATERIALS)).save(recipeOutput);
        SanguisRecipeProvider.smelting(recipeOutput, SanguisItems.STEEL_INGOT, SanguisItems.STEEL_BLEND);
        SanguisRecipeProvider.blasting(recipeOutput, SanguisItems.STEEL_INGOT, SanguisItems.STEEL_BLEND);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, SanguisItems.STEEL_CLEAVER).pattern("SSG").pattern("S/G").pattern("S/ ").define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).define(Character.valueOf('S'), SanguisItems.STEEL_INGOT).define(Character.valueOf('G'), SanguisItems.GARLIC).unlockedBy(SanguisRecipeProvider.getHasName(SanguisItems.STEEL_INGOT), SanguisRecipeProvider.has(SanguisItems.STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, SanguisItems.DIAMOND_CLEAVER).pattern("SDG").pattern("D/G").pattern("S/ ").define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).define(Character.valueOf('S'), SanguisItems.STEEL_INGOT).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('G'), SanguisItems.GARLIC).unlockedBy(SanguisRecipeProvider.getHasName((ItemLike)Items.DIAMOND), SanguisRecipeProvider.has((ItemLike)Items.DIAMOND)).save(recipeOutput);
        SanguisRecipeProvider.colorBlockWithDye((RecipeOutput)recipeOutput, dyes, coffins, (String)"coffin");
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.WHITE_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.LIGHT_GRAY_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.GRAY_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.BLACK_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.BROWN_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.RED_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.ORANGE_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.YELLOW_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.LIME_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.GREEN_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.CYAN_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.LIGHT_BLUE_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.BLUE_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.PURPLE_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.MAGENTA_COFFIN.get()));
        SanguisRecipeProvider.coffinFromPlanksAndWool(recipeOutput, (CoffinBlock)((Object)SanguisBlocks.PINK_COFFIN.get()));
    }

    private static void coffinFromPlanksAndWool(RecipeOutput recipeOutput, CoffinBlock block) {
        Item wool = WOOL_FROM_COLOR.get(block.getColor());
        if (wool == null) {
            Sanguis.LOGGER.debug("[SanguisRecipeProvider] No wool for color {} is defined", (Object)block.getColor().getName());
            return;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)block).pattern("XXX").pattern("###").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('#'), (ItemLike)wool).unlockedBy(SanguisRecipeProvider.getHasName((ItemLike)wool), SanguisRecipeProvider.has((ItemLike)wool)).save(recipeOutput);
    }

    private static void smelting(RecipeOutput recipeOutput, DeferredItem<Item> result, DeferredItem<Item> ingredient) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, result, (float)0.1f, (int)200).unlockedBy(SanguisRecipeProvider.getHasName(ingredient), SanguisRecipeProvider.has(ingredient)).save(recipeOutput, SanguisRecipeProvider.getSmeltingRecipeName(result));
    }

    private static void blasting(RecipeOutput recipeOutput, DeferredItem<Item> result, DeferredItem<Item> ingredient) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, result, (float)0.1f, (int)100).unlockedBy(SanguisRecipeProvider.getHasName(ingredient), SanguisRecipeProvider.has(ingredient)).save(recipeOutput, SanguisRecipeProvider.getBlastingRecipeName(result));
    }
}

