/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.recipe;

import com.feliscape.sanguis.registry.SanguisDataComponents;
import com.feliscape.sanguis.registry.SanguisIngredientTypes;
import com.feliscape.sanguis.registry.SanguisItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class BloodBottleIngredient
implements ICustomIngredient {
    public static final MapCodec<BloodBottleIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.optionalFieldOf("required_blood", (Object)1).forGetter(BloodBottleIngredient::getRequiredBlood)).apply((Applicative)builder, BloodBottleIngredient::new));
    public static final StreamCodec<ByteBuf, BloodBottleIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, BloodBottleIngredient::getRequiredBlood, BloodBottleIngredient::new);
    private int requiredBlood;

    protected int getRequiredBlood() {
        return this.requiredBlood;
    }

    public BloodBottleIngredient(int requiredBlood) {
        this.requiredBlood = requiredBlood;
    }

    public boolean test(ItemStack stack) {
        if (!stack.has(SanguisDataComponents.BLOOD)) {
            return false;
        }
        int blood = (Integer)stack.getOrDefault(SanguisDataComponents.BLOOD, (Object)0);
        return blood >= this.requiredBlood;
    }

    public Stream<ItemStack> getItems() {
        return Stream.of(SanguisItems.BLOOD_BOTTLE.toStack());
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return SanguisIngredientTypes.BLOOD_BOTTLE_INGREDIENT.get();
    }

    public static BloodBottleIngredient of(int requiredBlood) {
        return new BloodBottleIngredient(requiredBlood);
    }

    public static BloodBottleIngredient of() {
        return new BloodBottleIngredient(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BloodBottleIngredient)) return false;
        BloodBottleIngredient ingredient = (BloodBottleIngredient)obj;
        if (ingredient.requiredBlood != this.requiredBlood) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.requiredBlood);
    }
}

