/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.worldgen.registry;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.data.worldgen.registry.SanguisPlacedFeatures;
import com.feliscape.sanguis.registry.SanguisEntityTypes;
import com.feliscape.sanguis.registry.SanguisTags;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class SanguisBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_VAMPIRES = SanguisBiomeModifiers.createKey("add_vampires");
    public static final ResourceKey<BiomeModifier> ADD_WILD_GARLIC = SanguisBiomeModifiers.createKey("add_wild_garlic");
    public static final ResourceKey<BiomeModifier> ADD_COMMON_WILD_GARLIC = SanguisBiomeModifiers.createKey("add_common_wild_garlic");
    public static final ResourceKey<BiomeModifier> ADD_BLOOD_ORANGE_VINES = SanguisBiomeModifiers.createKey("add_blood_orange_vines");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        context.register(ADD_VAMPIRES, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(SanguisTags.Biomes.SPAWNS_VAMPIRES), List.of(new MobSpawnSettings.SpawnerData((EntityType)SanguisEntityTypes.VAMPIRE.get(), 70, 1, 2))));
        context.register(ADD_WILD_GARLIC, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(SanguisTags.Biomes.HAS_WILD_GARLIC), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(SanguisPlacedFeatures.WILD_GARLIC_PATCH)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_COMMON_WILD_GARLIC, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(SanguisTags.Biomes.HAS_COMMON_WILD_GARLIC), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(SanguisPlacedFeatures.WILD_GARLIC_PATCH_COMMON)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_BLOOD_ORANGE_VINES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(SanguisPlacedFeatures.BLOOD_ORANGE_VINE_PATCH)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Sanguis.location(name));
    }
}

