/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.worldgen.registry;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.content.block.BloodOrangeLeavesBlock;
import com.feliscape.sanguis.content.block.BloodOrangeVineBlock;
import com.feliscape.sanguis.data.worldgen.registry.SanguisPlacedFeatures;
import com.feliscape.sanguis.registry.SanguisBlocks;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class SanguisConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_GARLIC_PATCH = SanguisConfiguredFeatures.createKey("wild_garlic_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLOOD_ORANGE_VINE = SanguisConfiguredFeatures.createKey("blood_orange_vine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLOOD_ORANGE_VINE_PATCH = SanguisConfiguredFeatures.createKey("blood_orange_vine_patch");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        FeatureUtils.register(context, WILD_GARLIC_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)SanguisConfiguredFeatures.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)SanguisBlocks.WILD_GARLIC.get()))), List.of(), 7, 3, 64));
        WeightedStateProvider bloodOrangeLeavesProvider = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BloodOrangeLeavesBlock)((Object)SanguisBlocks.BLOOD_ORANGE_LEAVES.get())).defaultBlockState(), 4).add((Object)((BlockState)((BloodOrangeLeavesBlock)((Object)SanguisBlocks.BLOOD_ORANGE_LEAVES.get())).defaultBlockState().setValue((Property)BloodOrangeLeavesBlock.ORANGES, (Comparable)Boolean.TRUE)), 1));
        FeatureUtils.register(context, BLOOD_ORANGE_VINE, (Feature)Feature.BLOCK_COLUMN, (FeatureConfiguration)new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)UniformInt.of((int)4, (int)10), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BloodOrangeVineBlock)((Object)SanguisBlocks.BLOOD_ORANGE_VINE.get())).defaultBlockState().setValue((Property)BloodOrangeVineBlock.HEAD, (Comparable)Boolean.valueOf(false))))), BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)1), (BlockStateProvider)bloodOrangeLeavesProvider)), Direction.DOWN, BlockPredicate.ONLY_IN_AIR_PREDICATE, true));
        FeatureUtils.register(context, BLOOD_ORANGE_VINE_PATCH, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)new RandomPatchConfiguration(128, 7, 5, (Holder)placedFeatures.getOrThrow(SanguisPlacedFeatures.BLOOD_ORANGE_VINE)));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Sanguis.location(name));
    }

    public static RandomPatchConfiguration simpleRandomPatchConfiguration(int tries, Holder<PlacedFeature> feature, int xzSpread, int ySpread) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, feature);
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> RandomPatchConfiguration simplePatchConfiguration(F feature, FC config, List<Block> blocks, int xzSpread, int ySpread, int tries) {
        return SanguisConfiguredFeatures.simpleRandomPatchConfiguration(tries, (Holder<PlacedFeature>)PlacementUtils.filtered(feature, config, (BlockPredicate)SanguisConfiguredFeatures.simplePatchPredicate(blocks)), xzSpread, ySpread);
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> RandomPatchConfiguration simplePatchConfiguration(F feature, FC config, List<Block> blocks, int xzSpread, int ySpread) {
        return FeatureUtils.simplePatchConfiguration(feature, config, blocks, (int)96);
    }

    private static BlockPredicate simplePatchPredicate(List<Block> blocks) {
        BlockPredicate blockpredicate = !blocks.isEmpty() ? BlockPredicate.allOf((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), blocks)) : BlockPredicate.ONLY_IN_AIR_PREDICATE;
        return blockpredicate;
    }
}

