/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.worldgen.registry;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.data.worldgen.registry.SanguisConfiguredFeatures;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class SanguisPlacedFeatures {
    public static final ResourceKey<PlacedFeature> WILD_GARLIC_PATCH = SanguisPlacedFeatures.createKey("wild_garlic_patch");
    public static final ResourceKey<PlacedFeature> WILD_GARLIC_PATCH_COMMON = SanguisPlacedFeatures.createKey("wild_garlic_patch_common");
    public static final ResourceKey<PlacedFeature> BLOOD_ORANGE_VINE = SanguisPlacedFeatures.createKey("blood_orange_vine");
    public static final ResourceKey<PlacedFeature> BLOOD_ORANGE_VINE_PATCH = SanguisPlacedFeatures.createKey("blood_orange_vine_patch");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference wildGarlicPatchFeature = configuredFeatures.getOrThrow(SanguisConfiguredFeatures.WILD_GARLIC_PATCH);
        Holder.Reference bloodOrangeVineFeature = configuredFeatures.getOrThrow(SanguisConfiguredFeatures.BLOOD_ORANGE_VINE);
        Holder.Reference bloodOrangeVinePatchFeature = configuredFeatures.getOrThrow(SanguisConfiguredFeatures.BLOOD_ORANGE_VINE_PATCH);
        PlacementUtils.register(context, WILD_GARLIC_PATCH, (Holder)wildGarlicPatchFeature, (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)120), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, WILD_GARLIC_PATCH_COMMON, (Holder)wildGarlicPatchFeature, (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)50), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, BLOOD_ORANGE_VINE, (Holder)bloodOrangeVineFeature, (PlacementModifier[])new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1))});
        PlacementUtils.register(context, BLOOD_ORANGE_VINE_PATCH, (Holder)bloodOrangeVinePatchFeature, (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)20), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()});
    }

    public static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Sanguis.location(name));
    }
}

