/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.worldgen.registry;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.data.worldgen.registry.SanguisTemplatePools;
import com.feliscape.sanguis.registry.SanguisEntityTypes;
import com.feliscape.sanguis.registry.SanguisTags;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public class SanguisStructures {
    public static final ResourceKey<Structure> HUNTER_CAMP = SanguisStructures.createKey("hunter_camp");
    private static final Map<MobCategory, StructureSpawnOverride> HUNTER_CAMP_SPAWNS = Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)SanguisEntityTypes.VAMPIRE_HUNTER.get(), 1, 1, 1)})));

    public static void bootstrap(BootstrapContext<Structure> context) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        HolderGetter poolGetter = context.lookup(Registries.TEMPLATE_POOL);
        context.register(HUNTER_CAMP, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomeGetter.getOrThrow(SanguisTags.Biomes.HAS_HUNTER_CAMPS)).terrainAdapation(TerrainAdjustment.BEARD_THIN).spawnOverrides(HUNTER_CAMP_SPAWNS).build(), (Holder)poolGetter.getOrThrow(SanguisTemplatePools.HUNTER_CAMP_BASE), 3, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
    }

    private static ResourceKey<Structure> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)Sanguis.location(name));
    }
}

