/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.data.worldgen.registry;

import com.feliscape.sanguis.Sanguis;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class SanguisTemplatePools {
    public static final ResourceKey<StructureTemplatePool> HUNTER_CAMP_BASE = SanguisTemplatePools.createKey("hunter_camp/base");
    public static final ResourceKey<StructureTemplatePool> HUNTER_CAMP_QUEST_BOARD = SanguisTemplatePools.createKey("hunter_camp/quest_board");
    public static final ResourceKey<StructureTemplatePool> HUNTER_CAMP_TOWER = SanguisTemplatePools.createKey("hunter_camp/tower");
    public static final ResourceKey<StructureTemplatePool> HUNTER_CAMP_FEATURES = SanguisTemplatePools.createKey("hunter_camp/features");

    public static void bootstrap(BootstrapContext<StructureTemplatePool> context) {
        HolderGetter processorListGetter = context.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference mossify20Percent = processorListGetter.getOrThrow(ProcessorLists.MOSSIFY_20_PERCENT);
        HolderGetter poolGetter = context.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference empty = poolGetter.getOrThrow(Pools.EMPTY);
        context.register(HUNTER_CAMP_BASE, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/base")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(HUNTER_CAMP_QUEST_BOARD, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/quest_board/quest_board_0")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/quest_board/quest_board_1")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/quest_board/quest_board_2")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(HUNTER_CAMP_TOWER, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/tower_0"), (Holder)mossify20Percent), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/tower_1"), (Holder)mossify20Percent), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(HUNTER_CAMP_FEATURES, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.empty(), (Object)10), (Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/feature/food_tents")), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/feature/tents")), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/feature/garlic_farm")), (Object)5), (Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/feature/garlic_farm_large")), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/feature/storage")), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/feature/shrine"), (Holder)mossify20Percent), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)Sanguis.stringLocation("hunter_camp/feature/target_dummies")), (Object)4)), StructureTemplatePool.Projection.RIGID));
    }

    private static ResourceKey<StructureTemplatePool> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)Sanguis.location(name));
    }
}

