/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.mixin;

import com.feliscape.sanguis.util.VampireUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Unique
    private static final EntityDimensions BAT_DIMENSIONS = EntityDimensions.scalable((float)0.6f, (float)0.6f).withEyeHeight(0.4f);

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"getDefaultDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDefaultDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        if (VampireUtil.isVampire((Entity)this.self()) && VampireUtil.isBat((Entity)this.self())) {
            cir.setReturnValue((Object)BAT_DIMENSIONS);
        }
    }

    @Inject(method={"getFlyingSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    public void overrideBatFlyingSpeed(CallbackInfoReturnable<Float> cir) {
        if (VampireUtil.isBat((Entity)this.self())) {
            cir.setReturnValue((Object)Float.valueOf(this.isSprinting() ? 0.051999997f : 0.04f));
        }
    }
}

