/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.registry;

import com.feliscape.sanguis.content.block.BloodOrangeLeavesBlock;
import com.feliscape.sanguis.content.block.BloodOrangeVineBlock;
import com.feliscape.sanguis.content.block.CoffinBlock;
import com.feliscape.sanguis.content.block.GarlicCropBlock;
import com.feliscape.sanguis.content.block.GarlicStringBlock;
import com.feliscape.sanguis.content.block.QuestBoardBlock;
import com.feliscape.sanguis.content.block.WildGarlicBlock;
import com.feliscape.sanguis.registry.SanguisItems;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SanguisBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"sanguis");
    public static final DeferredBlock<QuestBoardBlock> QUEST_BOARD = SanguisBlocks.registerBlockWithItem("quest_board", p -> new QuestBoardBlock(p.mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(3.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<GarlicCropBlock> GARLIC = BLOCKS.registerBlock("garlic", p -> new GarlicCropBlock(p.mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<WildGarlicBlock> WILD_GARLIC = SanguisBlocks.registerBlockWithItem("wild_garlic", p -> new WildGarlicBlock(p.mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<GarlicStringBlock> GARLIC_STRING = SanguisBlocks.registerBlockWithItem("garlic_string", p -> new GarlicStringBlock(p.mapColor(MapColor.TERRACOTTA_MAGENTA).noCollission().instabreak().sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<BloodOrangeVineBlock> BLOOD_ORANGE_VINE = BLOCKS.registerBlock("blood_orange_vine", p -> new BloodOrangeVineBlock(p.mapColor(MapColor.PLANT).randomTicks().noCollission().instabreak().sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<BloodOrangeLeavesBlock> BLOOD_ORANGE_LEAVES = BLOCKS.registerBlock("blood_orange_leaves", p -> new BloodOrangeLeavesBlock(p.mapColor(MapColor.PLANT).randomTicks().noOcclusion().strength(0.2f).randomTicks().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(SanguisBlocks::never).isViewBlocking(SanguisBlocks::never).sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY).isRedstoneConductor(SanguisBlocks::never)));
    public static final DeferredBlock<CoffinBlock> WHITE_COFFIN = SanguisBlocks.registerCoffin(DyeColor.WHITE);
    public static final DeferredBlock<CoffinBlock> LIGHT_GRAY_COFFIN = SanguisBlocks.registerCoffin(DyeColor.LIGHT_GRAY);
    public static final DeferredBlock<CoffinBlock> GRAY_COFFIN = SanguisBlocks.registerCoffin(DyeColor.GRAY);
    public static final DeferredBlock<CoffinBlock> BLACK_COFFIN = SanguisBlocks.registerCoffin(DyeColor.BLACK);
    public static final DeferredBlock<CoffinBlock> BROWN_COFFIN = SanguisBlocks.registerCoffin(DyeColor.BROWN);
    public static final DeferredBlock<CoffinBlock> RED_COFFIN = SanguisBlocks.registerCoffin(DyeColor.RED);
    public static final DeferredBlock<CoffinBlock> ORANGE_COFFIN = SanguisBlocks.registerCoffin(DyeColor.ORANGE);
    public static final DeferredBlock<CoffinBlock> YELLOW_COFFIN = SanguisBlocks.registerCoffin(DyeColor.YELLOW);
    public static final DeferredBlock<CoffinBlock> LIME_COFFIN = SanguisBlocks.registerCoffin(DyeColor.LIME);
    public static final DeferredBlock<CoffinBlock> GREEN_COFFIN = SanguisBlocks.registerCoffin(DyeColor.GREEN);
    public static final DeferredBlock<CoffinBlock> CYAN_COFFIN = SanguisBlocks.registerCoffin(DyeColor.CYAN);
    public static final DeferredBlock<CoffinBlock> LIGHT_BLUE_COFFIN = SanguisBlocks.registerCoffin(DyeColor.LIGHT_BLUE);
    public static final DeferredBlock<CoffinBlock> BLUE_COFFIN = SanguisBlocks.registerCoffin(DyeColor.BLUE);
    public static final DeferredBlock<CoffinBlock> PURPLE_COFFIN = SanguisBlocks.registerCoffin(DyeColor.PURPLE);
    public static final DeferredBlock<CoffinBlock> MAGENTA_COFFIN = SanguisBlocks.registerCoffin(DyeColor.MAGENTA);
    public static final DeferredBlock<CoffinBlock> PINK_COFFIN = SanguisBlocks.registerCoffin(DyeColor.PINK);

    private static DeferredBlock<CoffinBlock> registerCoffin(DyeColor color) {
        return SanguisBlocks.registerBlockWithItem(color.getName() + "_coffin", p -> SanguisBlocks.coffin(p, color));
    }

    private static CoffinBlock coffin(BlockBehaviour.Properties properties, DyeColor color) {
        return new CoffinBlock(color, properties.mapColor(color.getMapColor()).sound(SoundType.WOOD).strength(0.2f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    }

    private static LeavesBlock leaves(BlockBehaviour.Properties properties, SoundType soundType) {
        return new LeavesBlock(properties.mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(soundType).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(SanguisBlocks::never).isViewBlocking(SanguisBlocks::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(SanguisBlocks::never));
    }

    private static LeavesBlock leaves(BlockBehaviour.Properties properties, SoundType soundType, MapColor mapColor) {
        return new LeavesBlock(properties.mapColor(mapColor).strength(0.2f).randomTicks().sound(soundType).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(SanguisBlocks::never).isViewBlocking(SanguisBlocks::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(SanguisBlocks::never));
    }

    private static boolean always(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    private static boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }

    private static ButtonBlock woodenButton(BlockSetType type) {
        return new ButtonBlock(type, 30, BlockBehaviour.Properties.of().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY));
    }

    private static <T extends Block> DeferredBlock<T> registerBlockWithItem(String name, Function<BlockBehaviour.Properties, ? extends T> block) {
        DeferredBlock toReturn = BLOCKS.registerBlock(name, block);
        SanguisBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredItem<Item> registerBlockItem(String name, DeferredBlock<T> block) {
        return SanguisItems.ITEMS.registerItem(name, p -> new BlockItem((Block)block.get(), p));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

