/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.registry;

import com.feliscape.sanguis.registry.SanguisBlocks;
import com.feliscape.sanguis.registry.SanguisItems;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SanguisCreativeModeTabs {
    private static final DeferredRegister<CreativeModeTab> REGISTER = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"sanguis");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BASE_CREATIVE_TAB = REGISTER.register("base", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.sanguis.base")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(() -> new ItemStack((ItemLike)SanguisItems.BLOODY_FANG.get())).displayItems((CreativeModeTab.DisplayItemsGenerator)new DisplayItemsGenerator()).build());

    public static void register(IEventBus eventBus) {
        REGISTER.register(eventBus);
    }

    private static class DisplayItemsGenerator
    implements CreativeModeTab.DisplayItemsGenerator {
        private DisplayItemsGenerator() {
        }

        private static Predicate<Item> makeExclusionPredicate() {
            ReferenceOpenHashSet exclusions = new ReferenceOpenHashSet();
            List<ItemLike> simpleExclusions = List.of();
            for (ItemLike entry : simpleExclusions) {
                exclusions.add(entry.asItem());
            }
            return ((Set)exclusions)::contains;
        }

        private List<Item> collectBlocks(Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (DeferredHolder entry : SanguisBlocks.BLOCKS.getEntries()) {
                Item item = ((Block)entry.get()).asItem();
                if (item == Items.AIR || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<Item> collectItems(Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (DeferredHolder entry : SanguisItems.ITEMS.getEntries()) {
                Item item = (Item)entry.get();
                if (item instanceof BlockItem || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            return items;
        }

        public void accept(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
            Predicate<Item> exclusionPredicate = DisplayItemsGenerator.makeExclusionPredicate();
            LinkedList<Item> items = new LinkedList<Item>();
            items.addAll(this.collectBlocks(exclusionPredicate));
            items.addAll(this.collectItems(exclusionPredicate));
            DisplayItemsGenerator.outputAll(output, items);
        }

        private static void outputAll(CreativeModeTab.Output output, List<Item> items) {
            for (Item item : items) {
                output.accept((ItemLike)item);
            }
        }
    }
}

