/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.almostunified_ie.plugin;

import com.almostreliable.unified.api.unification.bundled.GenericRecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.RecipeJson;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.UnificationHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;

public class IERecipeUnifier
implements RecipeUnifier {
    private static final String INPUT_0 = "input0";
    private static final String INPUT_1 = "input1";
    private static final String ADDITIVES = "additives";
    private static final String SOIL = "soil";
    private static final String SLAG = "slag";
    private static final String SECONDARIES = "secondaries";
    private static final String SECONDARY_OUTPUTS = "secondaryOutputs";
    private static final String STRIPPING_SECONDARIES = "strippingSecondaries";
    private static final String STRIPPED = "stripped";
    private static final String BASE_PREDICATE = "basePredicate";
    private static final String MOLD = "mold";
    private static final String CATALYST = "catalyst";

    public void unify(UnificationHelper helper, RecipeJson recipe) {
        GenericRecipeUnifier.INSTANCE.unify(helper, recipe);
        List.of(INPUT_0, INPUT_1, "input", "inputs", ADDITIVES, SOIL, CATALYST).forEach(key -> this.unifyInputs(helper, recipe, (String)key));
        List.of("result", "results", SLAG, SECONDARY_OUTPUTS, STRIPPING_SECONDARIES, STRIPPED).forEach(key -> helper.unifyOutputs(recipe, key, true, new String[]{BASE_PREDICATE, "output"}));
        this.unifySecondaries(helper, recipe);
        this.unifyMold(helper, recipe);
    }

    private void unifyInputs(UnificationHelper helper, RecipeJson recipe, String key) {
        Object object = recipe.getProperty(key);
        if (object instanceof JsonArray) {
            JsonArray json = (JsonArray)object;
            object = json.iterator();
            while (object.hasNext()) {
                JsonElement element = (JsonElement)object.next();
                if (!(element instanceof JsonObject)) continue;
                JsonObject jsonObject = (JsonObject)element;
                this.unifyBasePredicate(helper, jsonObject);
            }
        }
        if ((object = recipe.getProperty(key)) instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)object;
            this.unifyBasePredicate(helper, jsonObject);
        }
        helper.unifyInputs(recipe, new String[]{key});
    }

    private void unifyBasePredicate(UnificationHelper helper, JsonObject json) {
        if (json.has(BASE_PREDICATE)) {
            helper.unifyInputElement(json.get(BASE_PREDICATE), new String[0]);
        }
    }

    private void unifySecondaries(UnificationHelper helper, RecipeJson recipe) {
        JsonElement secondaries = recipe.getProperty(SECONDARIES);
        if (secondaries == null) {
            return;
        }
        helper.unifyOutputArray(secondaries.getAsJsonArray(), true, new String[]{"output"});
    }

    private void unifyMold(UnificationHelper helper, RecipeJson recipe) {
        JsonElement mold = recipe.getProperty(MOLD);
        if (!(mold instanceof JsonPrimitive)) {
            return;
        }
        JsonPrimitive moldJson = (JsonPrimitive)mold;
        JsonPrimitive replacement = helper.handleOutputItemReplacement(moldJson);
        if (replacement != null) {
            recipe.setProperty(MOLD, (JsonElement)replacement);
        }
    }
}

