/*
 * Decompiled with CFR 0.152.
 */
package com.pairzhu.mcdrcmdsuggest;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.annotation.JSONField;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.pairzhu.mcdrcmdsuggest.CommandInitializationException;
import com.pairzhu.mcdrcmdsuggest.CommandOperationException;
import com.pairzhu.mcdrcmdsuggest.CommandValidationException;
import com.pairzhu.mcdrcmdsuggest.HttpSuggestImplement;
import com.pairzhu.mcdrcmdsuggest.McdrCmdSuggest;
import com.pairzhu.mcdrcmdsuggest.Node;
import com.pairzhu.mcdrcmdsuggest.StdioSuggestImplement;
import com.pairzhu.mcdrcmdsuggest.SuggestImplement;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;

public class RegisterCommandHandler
implements Command<class_2168>,
AutoCloseable {
    private final Set<String> registeredCommands = new HashSet<String>();
    private SuggestImplement suggestImplement;

    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        MinecraftServer minecraftServer = ((class_2168)context.getSource()).method_9211();
        CommandDispatcher commandDispatcher = Objects.requireNonNull(minecraftServer).method_3734().method_9235();
        try {
            this.unregisterExistingCommands((CommandDispatcher<class_2168>)commandDispatcher);
            this.registerNewCommands(context, (CommandDispatcher<class_2168>)commandDispatcher);
            this.updatePlayerCommandTrees(minecraftServer);
            return 1;
        }
        catch (CommandOperationException e) {
            McdrCmdSuggest.LOGGER.error("Command operation failed: {}", (Throwable)e);
            throw new SimpleCommandExceptionType(() -> e.getMessage()).create();
        }
    }

    private void unregisterExistingCommands(CommandDispatcher<class_2168> dispatcher) throws CommandOperationException {
        if (this.registeredCommands.isEmpty()) {
            return;
        }
        try {
            Object rootNode = CommandFields.rootCommandNode.get(dispatcher);
            Map children = (Map)CommandFields.commandNodeChildren.get(rootNode);
            Map literals = (Map)CommandFields.commandNodeLiterals.get(rootNode);
            for (String commandName : this.registeredCommands) {
                children.remove(commandName);
                literals.remove(commandName);
                McdrCmdSuggest.LOGGER.debug("Unregistered command: {}", (Object)commandName);
            }
            this.registeredCommands.clear();
        }
        catch (IllegalAccessException e) {
            throw new CommandOperationException("Failed to unregister commands", e);
        }
    }

    private void registerNewCommands(CommandContext<class_2168> context, CommandDispatcher<class_2168> dispatcher) throws CommandOperationException {
        try {
            String jsonData = StringArgumentType.getString(context, (String)"json_data");
            CommandData commandData = this.parseCommandData(jsonData);
            McdrCmdSuggest.LOGGER.info("Processing commands in mode: {} with port: {}", (Object)commandData.mode, (Object)commandData.port);
            for (JSONObject nodeJson : commandData.commandNodes) {
                this.registerSingleCommand(nodeJson, dispatcher);
            }
        }
        catch (Exception e) {
            throw new CommandOperationException("Failed to register commands", e);
        }
    }

    private CommandData parseCommandData(String jsonData) throws CommandValidationException {
        CommandData commandData = (CommandData)JSON.parseObject((String)jsonData, CommandData.class);
        if (commandData == null || commandData.commandNodes == null) {
            throw new CommandValidationException("Invalid command data format: missing or empty data");
        }
        switch (commandData.mode.ordinal()) {
            case 0: {
                this.suggestImplement = new StdioSuggestImplement();
                break;
            }
            case 1: {
                if (commandData.port < 1 || commandData.port > 65535) {
                    throw new CommandValidationException("Invalid port number: must be between 1 and 65535");
                }
                this.suggestImplement = new HttpSuggestImplement(commandData.host, commandData.port);
                break;
            }
            default: {
                throw new CommandValidationException("Unsupported mode: " + (Object)((Object)commandData.mode));
            }
        }
        return commandData;
    }

    private void registerSingleCommand(JSONObject nodeJson, CommandDispatcher<class_2168> dispatcher) throws CommandOperationException {
        try {
            Node node = new Node(nodeJson, this.suggestImplement);
            LiteralArgumentBuilder brigadierNode = (LiteralArgumentBuilder)node.toBrigadierNode();
            dispatcher.register(brigadierNode);
            this.registeredCommands.add(node.name);
            McdrCmdSuggest.LOGGER.debug("Registered command: {}", (Object)node.name);
        }
        catch (Exception e) {
            throw new CommandOperationException(String.format("Failed to register command from node: %s", nodeJson), e);
        }
    }

    private void updatePlayerCommandTrees(MinecraftServer server) throws CommandOperationException {
        try {
            server.method_3760().method_14571().forEach(player -> Objects.requireNonNull(player.method_5682()).method_3760().method_14576(player));
        }
        catch (Exception e) {
            throw new CommandOperationException("Failed to update command tree for players", e);
        }
    }

    @Override
    public void close() {
        this.registeredCommands.clear();
    }

    private static class CommandFields {
        private static final Field rootCommandNode;
        private static final Field commandNodeChildren;
        private static final Field commandNodeLiterals;

        private CommandFields() {
        }

        static {
            try {
                rootCommandNode = CommandDispatcher.class.getDeclaredField("root");
                commandNodeChildren = CommandNode.class.getDeclaredField("children");
                commandNodeLiterals = CommandNode.class.getDeclaredField("literals");
                rootCommandNode.setAccessible(true);
                commandNodeChildren.setAccessible(true);
                commandNodeLiterals.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                String message = "Failed to initialize reflection fields for command handling";
                McdrCmdSuggest.LOGGER.error(message + "{}", (Throwable)e);
                throw new CommandInitializationException(message, e);
            }
        }
    }

    public static class CommandData {
        @JSONField(name="mode", required=true)
        public final Mode mode;
        @JSONField(name="host")
        public final String host;
        @JSONField(name="port")
        public final int port;
        @JSONField(name="nodes")
        public final List<JSONObject> commandNodes;

        public CommandData(Mode mode, String host, int port, List<JSONObject> commandNodes) {
            this.mode = mode;
            this.host = host == null ? "localhost" : host;
            this.port = port;
            this.commandNodes = commandNodes;
        }
    }

    public static enum Mode {
        STDIO,
        HTTP;

    }
}

