/*
 * Decompiled with CFR 0.152.
 */
package com.pairzhu.mcdrcmdsuggest;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.pairzhu.mcdrcmdsuggest.McdrCmdSuggest;
import com.pairzhu.mcdrcmdsuggest.SuggestImplement;
import java.util.ArrayList;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_3222;

public class Node {
    public final String name;
    private final String type;
    private final boolean suggestible;
    private final ArrayList<Node> children = new ArrayList();
    private final SuggestImplement suggestImplement;

    public Node(JSONObject json, SuggestImplement suggestImplement) {
        this.name = json.getString("name");
        this.type = json.getString("type");
        this.suggestible = json.getBooleanValue("suggestible");
        this.suggestImplement = suggestImplement;
        if (json.containsKey("children")) {
            for (JSONObject childJson : (JSONObject[])json.getJSONArray("children").toArray(JSONObject.class, new JSONReader.Feature[0])) {
                this.children.add(new Node(childJson, suggestImplement));
            }
        }
    }

    public ArgumentBuilder<class_2168, ?> toBrigadierNode() {
        RequiredArgumentBuilder argumentBuilder = this.createArgumentBuilder();
        if (this.needsSuggestion()) {
            if (this.suggestImplement == null) {
                throw new IllegalStateException("suggestImplement cannot be null when suggestions are needed");
            }
            RequiredArgumentBuilder requiredArgBuilder = argumentBuilder;
            requiredArgBuilder.suggests((context, builder) -> {
                class_3222 player = ((class_2168)context.getSource()).method_44023();
                if (player == null) {
                    return class_2172.method_9253((String[])new String[0], (SuggestionsBuilder)builder);
                }
                String input = builder.getInput();
                String command = input.startsWith("/") ? input.substring(1) : input;
                return class_2172.method_9253((String[])this.suggestImplement.getSuggestions(player, command), (SuggestionsBuilder)builder);
            });
            argumentBuilder = requiredArgBuilder;
        }
        argumentBuilder.executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            String input = context.getInput();
            String command = input.startsWith("/") ? input.substring(1) : input;
            String name = source != null ? source.method_9214() : "unknown";
            McdrCmdSuggest.LOGGER.info("<{}> {}", (Object)name, (Object)command);
            return 1;
        });
        if (this.children != null) {
            for (Node child : this.children) {
                argumentBuilder.then(child.toBrigadierNode());
            }
        }
        return argumentBuilder;
    }

    private ArgumentBuilder<class_2168, ?> createArgumentBuilder() {
        switch (this.type) {
            case "LITERAL": {
                return class_2170.method_9247((String)this.name);
            }
            case "INTEGER": {
                return class_2170.method_9244((String)this.name, (ArgumentType)IntegerArgumentType.integer());
            }
            case "FLOAT": {
                return class_2170.method_9244((String)this.name, (ArgumentType)DoubleArgumentType.doubleArg());
            }
            case "QUOTABLE_TEXT": {
                return class_2170.method_9244((String)this.name, (ArgumentType)StringArgumentType.string());
            }
            case "GREEDY_TEXT": {
                return class_2170.method_9244((String)this.name, (ArgumentType)StringArgumentType.greedyString());
            }
        }
        return class_2170.method_9244((String)this.name, (ArgumentType)StringArgumentType.word());
    }

    private boolean needsSuggestion() {
        return !"LITERAL".equals(this.type) && this.suggestible && this.suggestImplement != null;
    }
}

