/*
 * Decompiled with CFR 0.152.
 */
package net.bitzero.as_you_wish.init;

import net.bitzero.as_you_wish.entity.DesertSpiritEntity;
import net.bitzero.as_you_wish.entity.FreeGenieEntity;
import net.bitzero.as_you_wish.entity.GenieEntity;
import net.bitzero.as_you_wish.entity.GreenGenieBossEntity;
import net.bitzero.as_you_wish.entity.GreenGenieEntity;
import net.bitzero.as_you_wish.entity.GreenGenieLightningEntity;
import net.bitzero.as_you_wish.entity.RedGenieEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AsYouWishModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"as_you_wish");
    public static final RegistryObject<EntityType<GenieEntity>> GENIE = AsYouWishModEntities.register("genie", EntityType.Builder.m_20704_(GenieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(GenieEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<GreenGenieEntity>> GREEN_GENIE = AsYouWishModEntities.register("green_genie", EntityType.Builder.m_20704_(GreenGenieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(GreenGenieEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<GreenGenieBossEntity>> GREEN_GENIE_BOSS = AsYouWishModEntities.register("green_genie_boss", EntityType.Builder.m_20704_(GreenGenieBossEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(GreenGenieBossEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<GreenGenieLightningEntity>> GREEN_GENIE_LIGHTNING = AsYouWishModEntities.register("green_genie_lightning", EntityType.Builder.m_20704_(GreenGenieLightningEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(GreenGenieLightningEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.1f, 0.1f));
    public static final RegistryObject<EntityType<FreeGenieEntity>> FREE_GENIE = AsYouWishModEntities.register("free_genie", EntityType.Builder.m_20704_(FreeGenieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FreeGenieEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<RedGenieEntity>> RED_GENIE = AsYouWishModEntities.register("red_genie", EntityType.Builder.m_20704_(RedGenieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(RedGenieEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<DesertSpiritEntity>> DESERT_SPIRIT = AsYouWishModEntities.register("desert_spirit", EntityType.Builder.m_20704_(DesertSpiritEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(DesertSpiritEntity::new).m_20719_().m_20699_(1.0f, 1.6f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            GenieEntity.init();
            GreenGenieEntity.init();
            GreenGenieBossEntity.init();
            FreeGenieEntity.init();
            RedGenieEntity.init();
            DesertSpiritEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)GENIE.get(), GenieEntity.createAttributes().m_22265_());
        event.put((EntityType)GREEN_GENIE.get(), GreenGenieEntity.createAttributes().m_22265_());
        event.put((EntityType)GREEN_GENIE_BOSS.get(), GreenGenieBossEntity.createAttributes().m_22265_());
        event.put((EntityType)FREE_GENIE.get(), FreeGenieEntity.createAttributes().m_22265_());
        event.put((EntityType)RED_GENIE.get(), RedGenieEntity.createAttributes().m_22265_());
        event.put((EntityType)DESERT_SPIRIT.get(), DesertSpiritEntity.createAttributes().m_22265_());
    }
}

