/*
 * Decompiled with CFR 0.152.
 */
package net.bitzero.as_you_wish.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.bitzero.as_you_wish.AsYouWishMod;
import net.bitzero.as_you_wish.procedures.GetFloralWalkProcedure;
import net.bitzero.as_you_wish.procedures.GetImmortalityProcedure;
import net.bitzero.as_you_wish.procedures.GetOmnipresenceProcedure;
import net.bitzero.as_you_wish.procedures.GetTotemProcedure;
import net.bitzero.as_you_wish.procedures.RerollWishesProcedure;
import net.bitzero.as_you_wish.world.inventory.RareGenieChatting3VariantMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RareGenieChatting3VariantButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public RareGenieChatting3VariantButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public RareGenieChatting3VariantButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(RareGenieChatting3VariantButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(RareGenieChatting3VariantButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            RareGenieChatting3VariantButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = RareGenieChatting3VariantMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RerollWishesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            GetTotemProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            GetImmortalityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            GetOmnipresenceProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            GetFloralWalkProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AsYouWishMod.addNetworkMessage(RareGenieChatting3VariantButtonMessage.class, RareGenieChatting3VariantButtonMessage::buffer, RareGenieChatting3VariantButtonMessage::new, RareGenieChatting3VariantButtonMessage::handler);
    }
}

