/*
 * Decompiled with CFR 0.152.
 */
package org.malek.minmod;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.entity.EntityDimensions;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnGroup;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemGroups;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.util.Identifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.malek.minmod.entity.PlaneEntity;
import org.malek.minmod.item.PlaneItem;

public class Minmod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"minmod");
    public static final String MOD_ID = "minmod";
    public static final Set<UUID> CANCEL_NEXT_FALL_DAMAGE = ConcurrentHashMap.newKeySet();
    public static final EntityType<PlaneEntity> PLANE_ENTITY_TYPE = (EntityType)Registry.register((Registry)Registries.ENTITY_TYPE, (Identifier)new Identifier("minmod", "plane"), (Object)FabricEntityTypeBuilder.create((SpawnGroup)SpawnGroup.MISC, PlaneEntity::new).dimensions(EntityDimensions.fixed((float)1.5f, (float)0.5f)).build());
    public static final PlaneItem PLANE_ITEM = new PlaneItem(new Item.Settings().maxCount(1));
    public static final Item PLANE_WING_ITEM = new Item(new Item.Settings());

    public void onInitialize() {
        LOGGER.info("MinMod initializing - preparing plane functionality!");
        try {
            this.registerItems();
            LOGGER.info("MinMod initialized successfully!");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize MinMod", (Throwable)e);
        }
    }

    private void registerItems() {
        try {
            Registry.register((Registry)Registries.ITEM, (Identifier)new Identifier(MOD_ID, "plane_item"), (Object)((Object)PLANE_ITEM));
            Registry.register((Registry)Registries.ITEM, (Identifier)new Identifier(MOD_ID, "plane_wing"), (Object)PLANE_WING_ITEM);
            ItemGroupEvents.modifyEntriesEvent((RegistryKey)ItemGroups.TOOLS).register(content -> content.add((ItemConvertible)PLANE_ITEM));
            ItemGroupEvents.modifyEntriesEvent((RegistryKey)ItemGroups.INGREDIENTS).register(content -> content.add((ItemConvertible)PLANE_WING_ITEM));
            LOGGER.info("Items registered successfully!");
        }
        catch (Exception e) {
            LOGGER.error("Failed to register items", (Throwable)e);
        }
    }
}

