/*
 * Decompiled with CFR 0.152.
 */
package org.malek.minmod.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.client.render.entity.model.EntityModelLayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.malek.minmod.Minmod;
import org.malek.minmod.client.gui.PlaneSpeedHudOverlay;
import org.malek.minmod.client.model.PlaneEntityModel;
import org.malek.minmod.client.renderer.PlaneEntityRenderer;

public class MinmodClient
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"minmod-client");

    public void onInitializeClient() {
        try {
            LOGGER.info("Minmod client initializing...");
            this.registerTooltips();
            EntityRendererRegistry.register(Minmod.PLANE_ENTITY_TYPE, PlaneEntityRenderer::new);
            EntityModelLayerRegistry.registerModelLayer((EntityModelLayer)PlaneEntityRenderer.PLANE_MODEL_LAYER, PlaneEntityModel::getTexturedModelData);
            HudRenderCallback.EVENT.register((Object)new PlaneSpeedHudOverlay());
            LOGGER.info("Minmod client initialized successfully!");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize MinmodClient", (Throwable)e);
        }
    }

    private void registerTooltips() {
        try {
            ItemTooltipCallback.EVENT.register((stack, context, lines) -> {
                if (stack.getItem() == Minmod.PLANE_ITEM) {
                    // empty if block
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to register tooltips", (Throwable)e);
        }
    }
}

