/*
 * Decompiled with CFR 0.152.
 */
package org.malek.minmod.client.gui;

import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.font.TextRenderer;
import net.minecraft.client.gui.DrawContext;
import net.minecraft.client.network.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ItemEntity;
import net.minecraft.entity.decoration.ItemFrameEntity;
import net.minecraft.entity.decoration.painting.PaintingEntity;
import net.minecraft.text.Text;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.malek.minmod.entity.PlaneEntity;

public class PlaneSpeedHudOverlay
implements HudRenderCallback {
    private static final int HUD_TEXT_COLOR = 0xFFFFFF;
    private static final int ALTITUDE_BAR_COLOR = -16733492;
    private static final int ALTITUDE_BG_COLOR = -2144128205;
    private static final int SONAR_BG_COLOR = Integer.MIN_VALUE;
    private static final int SONAR_LINE_COLOR = -16711936;
    private static final int SONAR_GRID_COLOR = -2147450880;
    private static final int SONAR_BLIP_COLOR = -65536;
    private static final double SONAR_RANGE = 48.0;

    public void onHudRender(DrawContext drawContext, float tickDelta) {
        Entity entity;
        MinecraftClient client = MinecraftClient.getInstance();
        ClientPlayerEntity player = client.player;
        if (player != null && (entity = player.getVehicle()) instanceof PlaneEntity) {
            PlaneEntity plane = (PlaneEntity)entity;
            TextRenderer textRenderer = client.textRenderer;
            int screenWidth = drawContext.getScaledWindowWidth();
            int screenHeight = drawContext.getScaledWindowHeight();
            String speedText = String.format("Speed: %.2f", Float.valueOf(plane.getCurrentSpeed()));
            String takeoffSpeedText = String.format("Takeoff: %.2f", Float.valueOf(PlaneEntity.getTakeoffSpeedThreshold()));
            String stallSpeedText = String.format("Stall: %.2f", Float.valueOf(PlaneEntity.getStallSpeedThreshold()));
            drawContext.drawTextWithShadow(textRenderer, (Text)Text.literal((String)speedText), 10, 10, 0xFFFFFF);
            drawContext.drawTextWithShadow(textRenderer, (Text)Text.literal((String)takeoffSpeedText), 10, 20, 0xFFFFFF);
            drawContext.drawTextWithShadow(textRenderer, (Text)Text.literal((String)stallSpeedText), 10, 30, 0xFFFFFF);
            this.drawGpsInfo(drawContext, textRenderer, plane);
            this.drawAltitudeIndicator(drawContext, client, plane, screenWidth, screenHeight);
            this.drawSonarDisplay(drawContext, client, player, plane, screenWidth, screenHeight, tickDelta);
        }
    }

    private void drawGpsInfo(DrawContext drawContext, TextRenderer textRenderer, PlaneEntity plane) {
        int x = 10;
        int baseY = 50;
        String posXText = String.format("X: %.1f", plane.getX());
        String posYText = String.format("Y: %.1f (Alt)", plane.getY());
        String posZText = String.format("Z: %.1f", plane.getZ());
        drawContext.drawTextWithShadow(textRenderer, (Text)Text.literal((String)posXText), 10, 50, 0xFFFFFF);
        drawContext.drawTextWithShadow(textRenderer, (Text)Text.literal((String)posYText), 10, 60, 0xFFFFFF);
        drawContext.drawTextWithShadow(textRenderer, (Text)Text.literal((String)posZText), 10, 70, 0xFFFFFF);
    }

    private void drawAltitudeIndicator(DrawContext drawContext, MinecraftClient client, PlaneEntity plane, int screenWidth, int screenHeight) {
        int barWidth = 15;
        int barHeight = 100;
        int x = screenWidth - barWidth - 10;
        int y = (screenHeight - barHeight) / 2;
        drawContext.fill(x, y, x + barWidth, y + barHeight, -2144128205);
        float altitude = (float)plane.getY();
        float maxDisplayAltitude = 320.0f;
        float minDisplayAltitude = -64.0f;
        float altitudeRange = maxDisplayAltitude - minDisplayAltitude;
        float normalizedAltitude = MathHelper.clamp((float)((altitude - minDisplayAltitude) / altitudeRange), (float)0.0f, (float)1.0f);
        int fillHeight = (int)(normalizedAltitude * (float)barHeight);
        drawContext.fill(x, y + barHeight - fillHeight, x + barWidth, y + barHeight, -16733492);
        for (int i = 0; i <= 4; ++i) {
            int markerY = y + barHeight * i / 4;
            drawContext.drawHorizontalLine(x - 2, x, markerY, 0xFFFFFF);
        }
        if (client != null) {
            drawContext.drawTextWithShadow(client.textRenderer, (Text)Text.literal((String)String.format("%.0fm", Float.valueOf(altitude))), x - 35, y + barHeight / 2 - 4, 0xFFFFFF);
        }
    }

    private void drawSonarDisplay(DrawContext drawContext, MinecraftClient client, ClientPlayerEntity player, PlaneEntity plane, int screenWidth, int screenHeight, float tickDelta) {
        int sonarSize = 80;
        int sonarRadius = sonarSize / 2;
        int centerX = screenWidth / 2;
        int centerY = screenHeight - sonarRadius - 10;
        int x1 = centerX - sonarRadius;
        int y1 = centerY - sonarRadius;
        int x2 = centerX + sonarRadius;
        int y2 = centerY + sonarRadius;
        drawContext.fill(x1, y1, x2, y2, Integer.MIN_VALUE);
        drawContext.drawHorizontalLine(x1, x2, centerY, -2147450880);
        drawContext.drawVerticalLine(centerX, y1, y2, -2147450880);
        int numCircles = 3;
        for (int i = 1; i <= numCircles; ++i) {
            int radius = sonarRadius * i / numCircles;
            drawContext.drawHorizontalLine(centerX - radius, centerX + radius, centerY - radius, -2147450880);
            drawContext.drawHorizontalLine(centerX - radius, centerX + radius, centerY + radius, -2147450880);
            drawContext.drawVerticalLine(centerX - radius, centerY - radius, centerY + radius, -2147450880);
            drawContext.drawVerticalLine(centerX + radius, centerY - radius, centerY + radius, -2147450880);
        }
        if (client != null && client.world != null) {
            long time = client.world.getTime();
            float angle = ((float)time + tickDelta) * 6.0f % 360.0f;
            float radians = (float)Math.toRadians(angle - 90.0f);
            int lineEndX = centerX + (int)(Math.cos(radians) * (double)sonarRadius);
            int lineEndY = centerY + (int)(Math.sin(radians) * (double)sonarRadius);
            if (Math.abs(lineEndX - centerX) > Math.abs(lineEndY - centerY)) {
                int startX = Math.min(centerX, lineEndX);
                int endX = Math.max(centerX, lineEndX);
                if (lineEndX - centerX != 0) {
                    slope = (float)(lineEndY - centerY) / (float)(lineEndX - centerX);
                    for (int lx = startX; lx <= endX; ++lx) {
                        int ly = Math.round((float)centerY + slope * (float)(lx - centerX));
                        drawContext.fill(lx, ly, lx + 1, ly + 1, -16711936);
                    }
                } else {
                    drawContext.fill(startX, centerY, endX + 1, centerY + 1, -16711936);
                }
            } else {
                int startY = Math.min(centerY, lineEndY);
                int endY = Math.max(centerY, lineEndY);
                if (lineEndY - centerY != 0) {
                    slope = (float)(lineEndX - centerX) / (float)(lineEndY - centerY);
                    for (int ly = startY; ly <= endY; ++ly) {
                        int lx = Math.round((float)centerX + slope * (float)(ly - centerY));
                        drawContext.fill(lx, ly, lx + 1, ly + 1, -16711936);
                    }
                } else {
                    drawContext.fill(centerX, startY, centerX + 1, endY + 1, -16711936);
                }
            }
            Predicate<Entity> sonarPredicate = e -> e != null && e.isAlive() && e != player && !(e instanceof ItemFrameEntity) && !(e instanceof PaintingEntity) && !(e instanceof ItemEntity);
            List nearbyEntities = client.world.getOtherEntities((Entity)plane, plane.getBoundingBox().expand(48.0), sonarPredicate);
            Vec3d planePos = plane.getPos();
            float planeYawRad = -plane.getYaw() * ((float)Math.PI / 180);
            for (Entity entity : nearbyEntities) {
                Vec3d entityPos = entity.getPos();
                Vec3d relativePosWorld = entityPos.subtract(planePos);
                if (Math.abs(relativePosWorld.y) > 24.0) continue;
                Vec3d localPos = relativePosWorld.rotateY(planeYawRad);
                double distSq = localPos.x * localPos.x + localPos.z * localPos.z;
                if (!(distSq <= 2304.0)) continue;
                int blipX = centerX + (int)(localPos.x / 48.0 * (double)sonarRadius);
                int blipY = centerY - (int)(localPos.z / 48.0 * (double)sonarRadius);
                double distToCenter = Math.sqrt(Math.pow(blipX - centerX, 2.0) + Math.pow(blipY - centerY, 2.0));
                if (!(distToCenter <= (double)sonarRadius)) continue;
                drawContext.fill(blipX - 1, blipY - 1, blipX + 1, blipY + 1, -65536);
            }
        }
    }
}

