/*
 * Decompiled with CFR 0.152.
 */
package org.malek.minmod.client.model;

import net.minecraft.client.model.ModelData;
import net.minecraft.client.model.ModelPart;
import net.minecraft.client.model.ModelPartBuilder;
import net.minecraft.client.model.ModelPartData;
import net.minecraft.client.model.ModelTransform;
import net.minecraft.client.model.TexturedModelData;
import net.minecraft.client.render.VertexConsumer;
import net.minecraft.client.render.entity.model.EntityModel;
import net.minecraft.client.util.math.MatrixStack;
import org.malek.minmod.entity.PlaneEntity;

public class PlaneEntityModel
extends EntityModel<PlaneEntity> {
    private final ModelPart base;
    private final ModelPart body;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart tailFin;
    private final ModelPart horizontalStabilizer;
    private final ModelPart propellerSpinner;
    private final ModelPart propellerBlade1;
    private final ModelPart propellerBlade2;
    private final ModelPart frontWheelStrut;
    private final ModelPart frontWheel;
    private final ModelPart rearLeftWheelStrut;
    private final ModelPart rearLeftWheel;
    private final ModelPart rearRightWheelStrut;
    private final ModelPart rearRightWheel;

    public PlaneEntityModel(ModelPart root) {
        this.base = root;
        this.body = root.getChild("body");
        this.leftWing = root.getChild("left_wing");
        this.rightWing = root.getChild("right_wing");
        this.tailFin = root.getChild("tail_fin");
        this.horizontalStabilizer = root.getChild("horizontal_stabilizer");
        this.propellerSpinner = root.getChild("propeller_spinner");
        this.propellerBlade1 = this.propellerSpinner.getChild("propeller_blade1");
        this.propellerBlade2 = this.propellerSpinner.getChild("propeller_blade2");
        this.frontWheelStrut = root.getChild("front_wheel_strut");
        this.frontWheel = root.getChild("front_wheel");
        this.rearLeftWheelStrut = root.getChild("rear_left_wheel_strut");
        this.rearLeftWheel = root.getChild("rear_left_wheel");
        this.rearRightWheelStrut = root.getChild("rear_right_wheel_strut");
        this.rearRightWheel = root.getChild("rear_right_wheel");
    }

    public static TexturedModelData getTexturedModelData() {
        ModelData modelData = new ModelData();
        ModelPartData modelPartData = modelData.getRoot();
        ModelTransform commonPivot = ModelTransform.pivot((float)0.0f, (float)22.0f, (float)0.0f);
        modelPartData.addChild("body", ModelPartBuilder.create().uv(0, 0).cuboid(-4.0f, -2.0f, -12.0f, 8.0f, 4.0f, 24.0f), commonPivot);
        modelPartData.addChild("left_wing", ModelPartBuilder.create().uv(0, 28).cuboid(4.0f, -1.0f, -8.0f, 16.0f, 2.0f, 8.0f), commonPivot);
        modelPartData.addChild("right_wing", ModelPartBuilder.create().uv(0, 38).cuboid(-20.0f, -1.0f, -8.0f, 16.0f, 2.0f, 8.0f), commonPivot);
        modelPartData.addChild("tail_fin", ModelPartBuilder.create().uv(0, 48).cuboid(-1.0f, -7.0f, 10.0f, 2.0f, 6.0f, 2.0f), commonPivot);
        modelPartData.addChild("horizontal_stabilizer", ModelPartBuilder.create().uv(8, 48).cuboid(-6.0f, -0.5f, 9.0f, 12.0f, 1.0f, 4.0f), commonPivot);
        ModelPartData spinner = modelPartData.addChild("propeller_spinner", ModelPartBuilder.create().uv(40, 48).cuboid(-1.0f, -1.0f, -13.0f, 2.0f, 2.0f, 1.0f), commonPivot);
        spinner.addChild("propeller_blade1", ModelPartBuilder.create().uv(40, 51).cuboid(0.0f, -3.0f, -12.5f, 1.0f, 6.0f, 1.0f), ModelTransform.NONE);
        spinner.addChild("propeller_blade2", ModelPartBuilder.create().uv(44, 51).cuboid(-3.0f, 0.0f, -12.5f, 6.0f, 1.0f, 1.0f), ModelTransform.NONE);
        modelPartData.addChild("front_wheel_strut", ModelPartBuilder.create().uv(0, 56).cuboid(-0.5f, 0.0f, -10.0f, 1.0f, 1.0f, 1.0f), commonPivot);
        modelPartData.addChild("front_wheel", ModelPartBuilder.create().uv(4, 56).cuboid(-0.5f, 1.0f, -10.5f, 1.0f, 2.0f, 2.0f), commonPivot);
        modelPartData.addChild("rear_left_wheel_strut", ModelPartBuilder.create().uv(8, 56).cuboid(11.5f, 0.0f, -4.0f, 1.0f, 1.0f, 1.0f), commonPivot);
        modelPartData.addChild("rear_left_wheel", ModelPartBuilder.create().uv(12, 56).cuboid(11.5f, 1.0f, -4.5f, 1.0f, 2.0f, 2.0f), commonPivot);
        modelPartData.addChild("rear_right_wheel_strut", ModelPartBuilder.create().uv(16, 56).cuboid(-12.5f, 0.0f, -4.0f, 1.0f, 1.0f, 1.0f), commonPivot);
        modelPartData.addChild("rear_right_wheel", ModelPartBuilder.create().uv(20, 56).cuboid(-12.5f, 1.0f, -4.5f, 1.0f, 2.0f, 2.0f), commonPivot);
        return TexturedModelData.of((ModelData)modelData, (int)64, (int)64);
    }

    public void setAngles(PlaneEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.propellerSpinner.yaw = animationProgress * 0.5f;
    }

    public void render(MatrixStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        this.body.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.leftWing.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.rightWing.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.tailFin.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.horizontalStabilizer.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.propellerSpinner.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.frontWheelStrut.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.frontWheel.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.rearLeftWheelStrut.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.rearLeftWheel.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.rearRightWheelStrut.render(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.rearRightWheel.render(matrices, vertices, light, overlay, red, green, blue, alpha);
    }
}

