/*
 * Decompiled with CFR 0.152.
 */
package org.malek.minmod.client.renderer;

import net.minecraft.client.render.OverlayTexture;
import net.minecraft.client.render.VertexConsumer;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.entity.EntityRendererFactory;
import net.minecraft.client.render.entity.model.EntityModelLayer;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.entity.Entity;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.RotationAxis;
import org.malek.minmod.client.model.PlaneEntityModel;
import org.malek.minmod.entity.PlaneEntity;

public class PlaneEntityRenderer
extends EntityRenderer<PlaneEntity> {
    public static final EntityModelLayer PLANE_MODEL_LAYER = new EntityModelLayer(new Identifier("minmod", "plane_entity"), "main");
    private final PlaneEntityModel model;
    private static final Identifier TEXTURE = new Identifier("minmod", "textures/entity/plane_entity.png");

    public PlaneEntityRenderer(EntityRendererFactory.Context context) {
        super(context);
        this.model = new PlaneEntityModel(context.getPart(PLANE_MODEL_LAYER));
        this.shadowRadius = 0.5f;
    }

    public void render(PlaneEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, VertexConsumerProvider vertexConsumerProvider, int light) {
        matrixStack.push();
        matrixStack.translate(0.0, -0.6, 0.0);
        matrixStack.multiply(RotationAxis.POSITIVE_Y.rotationDegrees(180.0f - entityYaw));
        matrixStack.multiply(RotationAxis.POSITIVE_X.rotationDegrees(entity.getPitch(partialTicks)));
        VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(this.model.getLayer(this.getTexture(entity)));
        this.model.render(matrixStack, vertexConsumer, light, OverlayTexture.DEFAULT_UV, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.pop();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStack, vertexConsumerProvider, light);
    }

    public Identifier getTexture(PlaneEntity entity) {
        return TEXTURE;
    }
}

