/*
 * Decompiled with CFR 0.152.
 */
package org.malek.minmod.entity;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityDimensions;
import net.minecraft.entity.EntityPose;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MovementType;
import net.minecraft.entity.damage.DamageSource;
import net.minecraft.entity.effect.StatusEffectInstance;
import net.minecraft.entity.effect.StatusEffects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.malek.minmod.Minmod;

public class PlaneEntity
extends Entity {
    public static final Logger LOGGER = LogManager.getLogger((String)"MinModPlaneEntity");
    private float currentSpeed = 0.0f;
    private static final float MAX_SPEED = 1.8f;
    private static final float ACCELERATION = 0.025f;
    private static final float BRAKE_FORCE = 0.06f;
    private static final float NATURAL_DECELERATION_AIR = 0.008f;
    private static final float NATURAL_DECELERATION_GROUND = 0.025f;
    private static final float YAW_CONTROL_SENSITIVITY = 2.8f;
    private static final float PITCH_INTERPOLATION_FACTOR = 0.1f;
    private static final float MAX_PITCH = 45.0f;
    private static final float MIN_PITCH = -45.0f;
    private static final float TAKEOFF_SPEED_THRESHOLD = 0.75f;
    private static final float STALL_SPEED_THRESHOLD = 0.6f;
    private static final float LIFT_COEFFICIENT = 0.035f;
    private static final float GRAVITY_PULL = 0.045f;
    private static final float STALL_DESCENT_RATE = 0.03f;
    private static final float INITIAL_LIFT_BOOST = 0.15f;
    private boolean prevOnGroundState;
    private static final float LANDING_IMPACT_VELOCITY_NO_DAMAGE = 0.35f;
    private static final float LANDING_IMPACT_VELOCITY_LOW_DAMAGE_THRESHOLD = 0.55f;
    private static final float LANDING_IMPACT_VELOCITY_HIGH_DAMAGE_THRESHOLD = 1.0f;
    private static final float LANDING_DAMAGE_FACTOR_MODERATE = 4.0f;
    private static final float LANDING_DAMAGE_FACTOR_HARD = 8.0f;
    private static final float MAX_LANDING_DAMAGE = 10.0f;

    public PlaneEntity(EntityType<? extends PlaneEntity> type, World world) {
        super(type, world);
        this.noClip = false;
        this.setNoGravity(true);
        this.intersectionChecked = true;
        this.prevOnGroundState = this.isOnGround();
    }

    protected void fall(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
        if (onGround) {
            for (Entity passenger : this.getPassengersDeep()) {
                if (!(passenger instanceof LivingEntity)) continue;
                passenger.fallDistance = 0.0f;
            }
        }
        super.fall(heightDifference, onGround, landedState, landedPosition);
    }

    public boolean isCollidable() {
        return true;
    }

    public boolean canHit() {
        return !this.isRemoved();
    }

    public boolean canBeCollidedWith() {
        return !this.isRemoved();
    }

    public void tick() {
        boolean justLanded;
        super.tick();
        LivingEntity controllingPassenger = this.getControllingPassenger();
        Vec3d positionAtTickStart = this.getPos();
        if (controllingPassenger instanceof LivingEntity) {
            LivingEntity rider = controllingPassenger;
            float speedAtTickStart = this.currentSpeed;
            float yawChange = -rider.sidewaysSpeed * 2.8f;
            this.setYaw(this.getYaw() + yawChange);
            float targetRiderPitch = rider.getPitch() * 0.65f;
            float currentPlanePitch = this.getPitch();
            float newPitch = currentPlanePitch + (targetRiderPitch - currentPlanePitch) * 0.1f;
            this.setPitch(Math.max(-45.0f, Math.min(45.0f, newPitch)));
            float tentativeCurrentSpeed = speedAtTickStart;
            boolean attemptedPositiveAcceleration = false;
            if (rider.forwardSpeed > 0.0f) {
                tentativeCurrentSpeed += 0.025f * rider.forwardSpeed;
                attemptedPositiveAcceleration = true;
            } else if (rider.forwardSpeed < 0.0f) {
                tentativeCurrentSpeed += 0.06f * rider.forwardSpeed;
            }
            tentativeCurrentSpeed = this.isOnGround() ? (tentativeCurrentSpeed -= 0.025f) : (tentativeCurrentSpeed -= 0.008f);
            tentativeCurrentSpeed = Math.max(0.0f, Math.min(tentativeCurrentSpeed, 1.8f));
            Vec3d forwardDirForVel = Vec3d.fromPolar((float)this.getPitch(), (float)this.getYaw());
            Vec3d velocityForMove = forwardDirForVel.multiply((double)tentativeCurrentSpeed);
            double vx = velocityForMove.getX();
            double vy = velocityForMove.getY();
            double vz = velocityForMove.getZ();
            if (!this.isOnGround()) {
                if (tentativeCurrentSpeed > 0.75f) {
                    vy += (double)((tentativeCurrentSpeed - 0.75f) * 0.035f);
                } else if (tentativeCurrentSpeed < 0.6f && tentativeCurrentSpeed > 0.0f) {
                    vy -= (double)(0.03f * (1.0f - tentativeCurrentSpeed / 0.6f));
                }
                vy -= (double)0.045f;
            } else {
                vy = tentativeCurrentSpeed > 0.75f && rider.forwardSpeed > 0.0f && this.getPitch() < -2.0f ? (vy += (double)0.15f) : Math.max(0.0, vy);
            }
            this.setVelocity(vx, vy, vz);
            this.move(MovementType.SELF, this.getVelocity());
            Vec3d positionAfterMove = this.getPos();
            Vec3d actualDisplacementThisTick = positionAfterMove.subtract(positionAtTickStart);
            if (attemptedPositiveAcceleration && this.isOnGround()) {
                Vec3d horizontalForwardDir = Vec3d.fromPolar((float)0.0f, (float)this.getYaw()).normalize();
                double actualForwardDistance = actualDisplacementThisTick.dotProduct(horizontalForwardDir);
                double minForwardMovementThreshold = 0.01;
                if (rider.forwardSpeed > 0.0f && actualForwardDistance < minForwardMovementThreshold && tentativeCurrentSpeed > speedAtTickStart) {
                    this.currentSpeed = speedAtTickStart;
                    if (this.isOnGround()) {
                        this.currentSpeed -= 0.025f;
                    }
                    this.currentSpeed = Math.max(0.0f, Math.min(this.currentSpeed, 1.8f));
                } else {
                    this.currentSpeed = tentativeCurrentSpeed;
                }
            } else {
                this.currentSpeed = tentativeCurrentSpeed;
            }
        } else {
            this.currentSpeed = this.isOnGround() ? (this.currentSpeed -= 0.0375f) : (this.currentSpeed -= 0.008f);
            this.currentSpeed = Math.max(0.0f, this.currentSpeed);
            Vec3d oldVel = this.getVelocity();
            double vy = oldVel.y;
            if (!this.isOnGround()) {
                vy -= (double)0.045f;
                if (this.currentSpeed < 0.6f) {
                    vy -= (double)(0.03f * (1.0f - this.currentSpeed / 0.6f));
                }
            } else {
                vy = 0.0;
            }
            if (this.currentSpeed > 0.0f) {
                Vec3d forwardDirection = Vec3d.fromPolar((float)this.getPitch(), (float)this.getYaw());
                Vec3d newHorizontalVel = forwardDirection.multiply((double)this.currentSpeed);
                this.setVelocity(newHorizontalVel.x, vy, newHorizontalVel.z);
            } else {
                this.setVelocity(oldVel.x * 0.8, vy, oldVel.z * 0.8);
            }
            if (this.isOnGround() && this.getVelocity().lengthSquared() < 1.0E-4) {
                this.setVelocity(Vec3d.ZERO);
                this.currentSpeed = 0.0f;
            }
        }
        this.velocityModified = true;
        double yVelocityForLandingCheck = this.getVelocity().y;
        this.move(MovementType.SELF, this.getVelocity());
        boolean currentOnGroundStatus = this.isOnGround();
        boolean bl = justLanded = currentOnGroundStatus && !this.prevOnGroundState;
        if (controllingPassenger instanceof LivingEntity) {
            LivingEntity rider = controllingPassenger;
            rider.fallDistance = currentOnGroundStatus ? 0.0f : 0.0f;
            if (justLanded) {
                double impactSpeed = Math.abs(yVelocityForLandingCheck);
                LOGGER.info("Plane with {} landed. Impact Y-speed: {:.3f}", (Object)rider.getName().getString(), (Object)impactSpeed);
                if (impactSpeed > (double)0.35f) {
                    float damageAmount = 0.0f;
                    if (impactSpeed > (double)0.55f) {
                        if (impactSpeed > 1.0) {
                            damageAmount = 1.8f;
                            damageAmount += (float)((impactSpeed - 1.0) * 8.0);
                            LOGGER.info("Hard landing detected.");
                        } else {
                            damageAmount = (float)((impactSpeed - (double)0.55f) * 4.0);
                            LOGGER.info("Moderate landing detected.");
                        }
                    } else {
                        LOGGER.info("Soft landing, below low damage threshold. No damage.");
                    }
                    if (damageAmount > 0.0f) {
                        damageAmount = Math.min(damageAmount, 10.0f);
                        damageAmount = Math.max(0.5f, damageAmount);
                        LOGGER.info("Applying {:.2f} landing damage to {}.", (Object)Float.valueOf(damageAmount), (Object)rider.getName().getString());
                    }
                } else {
                    LOGGER.info("Very soft touch down (below NO_DAMAGE threshold). No damage.");
                }
            }
        }
        if (currentOnGroundStatus) {
            this.setVelocity(this.getVelocity().x, 0.0, this.getVelocity().z);
        }
        this.prevOnGroundState = currentOnGroundStatus;
    }

    protected void initDataTracker() {
    }

    protected void readCustomDataFromNbt(NbtCompound nbt) {
        if (nbt.contains("CurrentSpeed", 5)) {
            this.currentSpeed = nbt.getFloat("CurrentSpeed");
        }
        this.prevOnGroundState = this.isOnGround();
    }

    protected void writeCustomDataToNbt(NbtCompound nbt) {
        nbt.putFloat("CurrentSpeed", this.currentSpeed);
    }

    public boolean isPushable() {
        return true;
    }

    public EntityDimensions getDimensions(EntityPose pose) {
        return EntityDimensions.fixed((float)1.5f, (float)0.5f);
    }

    public boolean canBeControlledByRider() {
        return true;
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        if (!this.getWorld().isClient && passenger instanceof LivingEntity) {
            LivingEntity livingPassenger = (LivingEntity)passenger;
            livingPassenger.addStatusEffect(new StatusEffectInstance(StatusEffects.SLOW_FALLING, Integer.MAX_VALUE, 0, true, false, true));
            LOGGER.info("Applied Slow Falling to passenger {}", (Object)livingPassenger.getName().getString());
            livingPassenger.addStatusEffect(new StatusEffectInstance(StatusEffects.RESISTANCE, Integer.MAX_VALUE, 4, true, false, true));
            LOGGER.info("Applied Resistance V (Invincibility) to passenger {}", (Object)livingPassenger.getName().getString());
        }
    }

    public LivingEntity getControllingPassenger() {
        List passengers = this.getPassengerList();
        if (passengers.isEmpty()) {
            return null;
        }
        Entity firstPassenger = (Entity)passengers.get(0);
        return firstPassenger instanceof LivingEntity ? (LivingEntity)firstPassenger : null;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengerList().isEmpty();
    }

    public double getMountedHeightOffset() {
        return 0.1;
    }

    protected void updatePassengerPosition(Entity passenger, Entity.PositionUpdater positionUpdater) {
        if (this.hasPassenger(passenger)) {
            double yPos = this.getY() + this.getMountedHeightOffset();
            positionUpdater.accept(passenger, this.getX(), yPos, this.getZ());
            float planeYaw = this.getYaw();
            passenger.setYaw(planeYaw);
            passenger.setBodyYaw(planeYaw);
            passenger.setOnGround(this.isOnGround());
            if (passenger instanceof LivingEntity) {
                LivingEntity livingPassenger = (LivingEntity)passenger;
                if (this.isOnGround()) {
                    livingPassenger.fallDistance = 0.0f;
                }
            }
        }
    }

    public float getCurrentSpeed() {
        return this.currentSpeed;
    }

    public static float getTakeoffSpeedThreshold() {
        return 0.75f;
    }

    public static float getStallSpeedThreshold() {
        return 0.6f;
    }

    public void removePassenger(Entity passenger) {
        if (this.getWorld().isClient) {
            super.removePassenger(passenger);
            return;
        }
        super.removePassenger(passenger);
        LOGGER.info("Dismount allowed for {} (server decision).", (Object)passenger.getName().getString());
        if (passenger instanceof LivingEntity) {
            LivingEntity livingPassenger = (LivingEntity)passenger;
            livingPassenger.removeStatusEffect(StatusEffects.SLOW_FALLING);
            livingPassenger.removeStatusEffect(StatusEffects.RESISTANCE);
            LOGGER.info("Removed effects from {} after dismount.", (Object)livingPassenger.getName().getString());
            if (livingPassenger instanceof PlayerEntity) {
                Minmod.CANCEL_NEXT_FALL_DAMAGE.add(livingPassenger.getUuid());
                LOGGER.info("Added {} to CANCEL_NEXT_FALL_DAMAGE set for next fall.", (Object)livingPassenger.getName().getString());
            }
            livingPassenger.fallDistance = 0.0f;
        }
    }

    public ActionResult interact(PlayerEntity player, Hand hand) {
        LOGGER.error("!!! PlaneEntity INTERACT method CALLED. Player: {} ({}), Hand: {}, World is client: {}", (Object)player.getName().getString(), (Object)player.getUuidAsString(), (Object)hand, (Object)this.getWorld().isClient);
        System.out.println("!!! PlaneEntity INTERACT method CALLED VIA STDOUT. Player: " + player.getName().getString() + ", World is client: " + this.getWorld().isClient);
        if (player.isSneaking()) {
            LOGGER.info("Player is sneaking. Passing interaction.");
            return ActionResult.PASS;
        }
        if (this.getPassengerList().isEmpty()) {
            LOGGER.info("Plane is empty.");
            if (!this.getWorld().isClient) {
                LOGGER.info("Executing startRiding on server for player {}.", (Object)player.getName().getString());
                boolean success = player.startRiding((Entity)this);
                LOGGER.info("startRiding call returned: {}", (Object)success);
                if (success) {
                    return ActionResult.SUCCESS;
                }
                return ActionResult.FAIL;
            }
            return ActionResult.SUCCESS;
        }
        LOGGER.info("Plane is not empty. Current passengers: {}. First passenger: {}", (Object)this.getPassengerList().size(), (Object)(this.getPassengerList().isEmpty() ? "N/A" : ((Entity)this.getPassengerList().get(0)).getName().getString()));
        return ActionResult.PASS;
    }

    public boolean damage(DamageSource source, float amount) {
        LOGGER.error("!!! PlaneEntity DAMAGE method CALLED. Source: {}, Amount: {}, World is client: {}", (Object)source.getName(), (Object)Float.valueOf(amount), (Object)this.getWorld().isClient);
        System.out.println("!!! PlaneEntity DAMAGE method CALLED VIA STDOUT. Source: " + source.getName() + ", World is client: " + this.getWorld().isClient);
        if (this.getWorld().isClient || this.isRemoved()) {
            LOGGER.info("Damage check: Is client or removed. Returning false.");
            return false;
        }
        Entity attacker = source.getAttacker();
        if (attacker instanceof PlayerEntity) {
            PlayerEntity attackerPlayer = (PlayerEntity)attacker;
            LOGGER.info("Damage check: Attacker is PlayerEntity: {}", (Object)attackerPlayer.getName().getString());
            if (!attackerPlayer.getAbilities().creativeMode) {
                LOGGER.info("Damage check: Player {} not in creative. Dropping item.", (Object)attackerPlayer.getName().getString());
                this.dropStack(new ItemStack((ItemConvertible)Minmod.PLANE_ITEM));
            } else {
                LOGGER.info("Damage check: Player {} in creative. Not dropping item.", (Object)attackerPlayer.getName().getString());
            }
        } else {
            LOGGER.info("Damage check: Attacker is not PlayerEntity or is null. Actual attacker: {}", (Object)(attacker != null ? attacker.getClass().getName() : "null"));
        }
        this.discard();
        LOGGER.info("PlaneEntity discarded.");
        return true;
    }
}

