/*
 * Decompiled with CFR 0.152.
 */
package org.malek.minmod.item;

import java.util.List;
import net.minecraft.client.item.TooltipContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUsageContext;
import net.minecraft.text.Text;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.TypedActionResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.malek.minmod.Minmod;
import org.malek.minmod.entity.PlaneEntity;

public class PlaneItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger((String)"minmod-plane");

    public PlaneItem(Item.Settings settings) {
        super(settings.maxDamage(250));
    }

    public TypedActionResult<ItemStack> use(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.getStackInHand(hand);
        try {
            if (!world.isClient) {
                player.setVelocity(player.getRotationVector().multiply(1.5));
                player.fallDistance = 0.0f;
                stack.damage(1, (LivingEntity)player, p -> p.sendToolBreakStatus(hand));
                player.getItemCooldownManager().set((Item)this, 20);
            }
            return TypedActionResult.success((Object)stack);
        }
        catch (Exception e) {
            LOGGER.error("Error when using PlaneItem", (Throwable)e);
            return TypedActionResult.pass((Object)stack);
        }
    }

    public void appendTooltip(ItemStack stack, World world, List<Text> tooltip, TooltipContext context) {
        try {
            tooltip.add((Text)Text.literal((String)"Right-click a block to place and ride the plane!"));
        }
        catch (Exception e) {
            LOGGER.error("Error appending tooltip for PlaneItem", (Throwable)e);
        }
    }

    public ActionResult useOnBlock(ItemUsageContext context) {
        World world = context.getWorld();
        PlayerEntity player = context.getPlayer();
        ItemStack stack = context.getStack();
        if (!world.isClient) {
            Vec3d pos = context.getHitPos();
            PlaneEntity plane = new PlaneEntity(Minmod.PLANE_ENTITY_TYPE, world);
            plane.refreshPositionAndAngles(pos.x, pos.y, pos.z, player != null ? player.getYaw() : 0.0f, 0.0f);
            world.spawnEntity((Entity)plane);
            if (player != null && !player.getAbilities().creativeMode) {
                stack.decrement(1);
            }
            return ActionResult.SUCCESS;
        }
        return ActionResult.CONSUME;
    }
}

