/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.capabilities;

import com.dracolich777.afterlifeentombed.capabilities.GodseekerSwordCapability;
import com.dracolich777.afterlifeentombed.items.GodstoneItem;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GodseekerSwordCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private final ItemStack stack;
    private final ItemStackHandler itemHandler;
    private final LazyOptional<IItemHandler> handlerLazyOptional;

    public GodseekerSwordCapabilityProvider(ItemStack stack, int size) {
        this.stack = stack;
        this.itemHandler = this.createHandler(size);
        this.handlerLazyOptional = LazyOptional.of(() -> this.itemHandler);
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.m_41720_() instanceof GodstoneItem;
            }

            protected void onContentsChanged(int slot) {
                GodseekerSwordCapabilityProvider.this.stack.m_41784_().m_128365_("GodstoneInventory", (Tag)this.serializeNBT());
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == GodseekerSwordCapability.GODSTONE_INVENTORY_CAPABILITY) {
            return this.handlerLazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.itemHandler.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.itemHandler.deserializeNBT(nbt);
    }
}

