/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.client;

import com.dracolich777.afterlifeentombed.effects.RevengeOfAnubisEffect;
import com.dracolich777.afterlifeentombed.init.ModEffects;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="afterlifeentombed", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class FrozenHeartsOverlay {
    private static final ResourceLocation FROZEN_HEART_TEXTURE = new ResourceLocation("afterlifeentombed", "textures/gui/frozen_heart_texture.png");

    @SubscribeEvent
    public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() != VanillaGuiOverlay.PLAYER_HEALTH.type()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (!FrozenHeartsOverlay.shouldRenderHealthBar(minecraft, player)) {
            return;
        }
        MobEffectInstance effect = player.m_21124_((MobEffect)ModEffects.REVENGE_OF_ANUBIS.get());
        if (effect == null) {
            return;
        }
        int frozenHearts = RevengeOfAnubisEffect.getFrozenHearts(effect.m_19564_());
        if (frozenHearts <= 0) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int totalHearts = (int)Math.ceil(player.m_21233_() / 2.0f);
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        int healthBarX = screenWidth / 2 - 91;
        int healthBarY = screenHeight - 39;
        if (minecraft.f_91072_.m_105205_()) {
            healthBarY += 0;
        }
        FrozenHeartsOverlay.renderFrozenHearts(guiGraphics, healthBarX, healthBarY, totalHearts, frozenHearts);
    }

    private static boolean shouldRenderHealthBar(Minecraft minecraft, LocalPlayer player) {
        if (minecraft.f_91072_.m_105295_() == GameType.CREATIVE) {
            return false;
        }
        if (minecraft.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return false;
        }
        if (minecraft.f_91066_.f_92062_) {
            return false;
        }
        if (player.m_21233_() <= 0.0f) {
            return false;
        }
        return minecraft.f_91072_.m_105205_();
    }

    private static void renderFrozenHearts(GuiGraphics guiGraphics, int startX, int startY, int totalHearts, int frozenHearts) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int firstFrozenHeart = totalHearts - frozenHearts;
        for (int i = 0; i < totalHearts; ++i) {
            if (i < firstFrozenHeart) continue;
            int heartRow = i / 10;
            int heartCol = i % 10;
            int heartX = startX + heartCol * 8;
            int heartY = startY - heartRow * 10;
            guiGraphics.m_280163_(FROZEN_HEART_TEXTURE, heartX, heartY, 0.0f, 0.0f, 9, 9, 9, 9);
        }
        RenderSystem.disableBlend();
    }
}

