/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.effects;

import com.dracolich777.afterlifeentombed.init.ModEffects;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RevengeOfAnubisEffect
extends MobEffect {
    public RevengeOfAnubisEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public static int getFrozenHearts(int amplifier) {
        return amplifier + 0;
    }

    public static boolean isHeartFrozen(LivingEntity entity, int heartIndex) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        MobEffectInstance effect = player.m_21124_((MobEffect)ModEffects.REVENGE_OF_ANUBIS.get());
        if (effect == null) {
            return false;
        }
        int frozenHearts = RevengeOfAnubisEffect.getFrozenHearts(effect.m_19564_());
        int totalHearts = (int)Math.ceil(player.m_21233_() / 2.0f);
        return heartIndex >= totalHearts - frozenHearts;
    }

    public static float getEffectiveMaxHealth(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return entity.m_21233_();
        }
        Player player = (Player)entity;
        MobEffectInstance effect = player.m_21124_((MobEffect)ModEffects.REVENGE_OF_ANUBIS.get());
        if (effect == null) {
            return entity.m_21233_();
        }
        int frozenHearts = RevengeOfAnubisEffect.getFrozenHearts(effect.m_19564_());
        return Math.max(2.0f, entity.m_21233_() - (float)frozenHearts * 2.0f);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level level = entity.m_9236_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float effectiveMaxHealth = RevengeOfAnubisEffect.getEffectiveMaxHealth((LivingEntity)player);
            if (player.m_21223_() > effectiveMaxHealth) {
                player.m_21153_(effectiveMaxHealth);
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 6; ++i) {
                double angle = (double)i / 6.0 * Math.PI * 2.0;
                double x = entity.m_20185_() + Math.cos(angle) * 1.2;
                double z = entity.m_20189_() + Math.sin(angle) * 1.2;
                double y = entity.m_20186_() + (double)entity.m_20206_() * 0.3;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.0, 0.1, 0.0, 0.01);
                if (!(entity.m_217043_().m_188501_() < 0.4f)) continue;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, y + 0.5, z, 1, 0.0, 0.05, 0.0, 0.02);
            }
            if (entity.m_217043_().m_188501_() < 0.3f) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123811_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.8, entity.m_20189_(), 2, 0.2, 0.2, 0.2, 0.1);
            }
        }
        if (entity.m_217043_().m_188501_() < 0.08f) {
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 0.3f, 0.7f);
        }
        if (amplifier >= 2 && entity.m_217043_().m_188501_() < 0.02f) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0));
        }
        if (amplifier >= 4 && entity.m_217043_().m_188501_() < 0.05f) {
            DamageSource damageSource = new DamageSource((Holder)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268515_));
            entity.m_6469_(damageSource, 1.5f);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    public boolean m_8093_() {
        return false;
    }
}

