/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.items;

import com.dracolich777.afterlifeentombed.client.model.ArmorOfRaModel;
import com.dracolich777.afterlifeentombed.client.model.ModModelLayers;
import com.dracolich777.afterlifeentombed.init.ModEffects;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ArmorOfRa
extends ArmorItem {
    public ArmorOfRa(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_ && this.hasFullSet(player)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100, 0, false, false, false));
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = event.getSource().m_7639_();
            if (livingEntity instanceof LivingEntity) {
                LivingEntity attacker = livingEntity;
                if (this.hasFullSet(player)) {
                    attacker.m_7292_(new MobEffectInstance((MobEffect)ModEffects.HOLY_FIRE.get(), 200, 0));
                }
            }
        }
    }

    private boolean hasFullSet(Player player) {
        return player.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ArmorOfRa && player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorOfRa && player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ArmorOfRa && player.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof ArmorOfRa;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.armor_of_ra.tooltip.line1").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.armor_of_ra.tooltip.set_bonus").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.armor_of_ra.tooltip.fire_resistance").m_130940_(ChatFormatting.RED));
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.armor_of_ra.tooltip.holy_fire").m_130940_(ChatFormatting.LIGHT_PURPLE));
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.armor_of_ra.tooltip.unbreakable").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD}));
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public boolean m_41465_() {
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                EntityModelSet entityModels = Minecraft.m_91087_().m_167973_();
                ModelPart modelPart = entityModels.m_171103_(ModModelLayers.getArmorLayer(equipmentSlot));
                return new ArmorOfRaModel(modelPart);
            }
        });
    }
}

