/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.items;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class GodseekerSword
extends SwordItem {
    private static final Map<String, String> GODSTONE_EFFECTS = new HashMap<String, String>();

    public GodseekerSword(Item.Properties pProperties) {
        super((Tier)Tiers.NETHERITE, 3, -2.4f, pProperties);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        String effectName;
        boolean result = super.m_7579_(pStack, pTarget, pAttacker);
        ItemStack godstoneeItem = GodseekerSword.getGodstoneeItem(pStack);
        if (!godstoneeItem.m_41619_() && (effectName = this.getEffectFromGodstone(godstoneeItem)) != null) {
            this.applyGodstoneeEffect(pTarget, effectName);
        }
        return result;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        ItemStack godstoneeItem = GodseekerSword.getGodstoneeItem(pStack);
        if (!godstoneeItem.m_41619_()) {
            String effectName = this.getEffectFromGodstone(godstoneeItem);
            if (effectName != null) {
                String displayName = this.getEffectDisplayName(effectName);
                pTooltipComponents.add((Component)Component.m_237113_((String)("Power: " + displayName)).m_130940_(ChatFormatting.GOLD));
            }
        } else {
            pTooltipComponents.add((Component)Component.m_237113_((String)"No godstone inserted").m_130940_(ChatFormatting.GRAY));
        }
        pTooltipComponents.add((Component)Component.m_237113_((String)"Hover to insert godstone").m_130940_(ChatFormatting.AQUA));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public static ItemStack getGodstoneeItem(ItemStack swordStack) {
        CompoundTag tag = swordStack.m_41784_();
        if (tag.m_128441_("GodstoneeItem")) {
            CompoundTag godstoneeTag = tag.m_128469_("GodstoneeItem");
            return ItemStack.m_41712_((CompoundTag)godstoneeTag);
        }
        return ItemStack.f_41583_;
    }

    public static void setGodstoneeItem(ItemStack swordStack, ItemStack godstoneeItem) {
        CompoundTag tag = swordStack.m_41784_();
        if (godstoneeItem.m_41619_()) {
            tag.m_128473_("GodstoneeItem");
        } else {
            CompoundTag godstoneeTag = new CompoundTag();
            godstoneeItem.m_41739_(godstoneeTag);
            tag.m_128365_("GodstoneeItem", (Tag)godstoneeTag);
        }
    }

    public static boolean isValidGodstone(ItemStack item) {
        if (item.m_41619_()) {
            return false;
        }
        String itemKey = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()).toString();
        return GODSTONE_EFFECTS.containsKey(itemKey);
    }

    private String getEffectFromGodstone(ItemStack godstoneeItem) {
        String itemKey = ForgeRegistries.ITEMS.getKey((Object)godstoneeItem.m_41720_()).toString();
        return GODSTONE_EFFECTS.get(itemKey);
    }

    private String getEffectDisplayName(String effectName) {
        switch (effectName) {
            case "holy_fire": {
                return "Holy Fire of Ra";
            }
            case "revenge_of_anubis": {
                return "Revenge of Anubis";
            }
            case "revenge_of_isis": {
                return "Revenge of Isis";
            }
            case "revenge_of_osiris": {
                return "Revenge of Osiris";
            }
            case "revenge_of_thoth": {
                return "Revenge of Thoth";
            }
            case "revenge_of_horus": {
                return "Revenge of Horus";
            }
            case "revenge_of_sobek": {
                return "Revenge of Sobek";
            }
            case "revenge_of_bastet": {
                return "Revenge of Bastet";
            }
        }
        return "Unknown Power";
    }

    private void applyGodstoneeEffect(LivingEntity target, String effectName) {
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("afterlifeentombed", effectName));
        if (effect != null) {
            target.m_7292_(new MobEffectInstance(effect, 200, 0));
        }
    }

    static {
        GODSTONE_EFFECTS.put("afterlifeentombed:godstone_of_ra", "holy_fire");
        GODSTONE_EFFECTS.put("afterlifeentombed:godstone_of_anubis", "revenge_of_anubis");
        GODSTONE_EFFECTS.put("afterlifeentombed:godstone_of_isis", "revenge_of_isis");
        GODSTONE_EFFECTS.put("afterlifeentombed:godstone_of_seth", "revenge_of_seth");
        GODSTONE_EFFECTS.put("afterlifeentombed:godstone_of_thoth", "revenge_of_thoth");
        GODSTONE_EFFECTS.put("afterlifeentombed:godstone_of_horus", "revenge_of_horus");
        GODSTONE_EFFECTS.put("afterlifeentombed:godstone_of_geb", "revenge_of_geb");
        GODSTONE_EFFECTS.put("afterlifeentombed:godstone_of_shu", "revenge_of_shu");
    }
}

