/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.items;

import com.dracolich777.afterlifeentombed.init.ModEffects;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class TokenOfHorus
extends Item
implements ICurioItem {
    private static final int COOLDOWN_TICKS = 6000;
    private static final String COOLDOWN_TAG = "EyeOfHorusCooldown";

    public TokenOfHorus(Item.Properties properties) {
        super(properties);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean m_5812_(ItemStack pStack) {
        return true;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11880_, SoundSource.PLAYERS, 1.0f, 1.5f);
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Integer.MAX_VALUE, 0, false, false, true));
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        entity.m_21195_(MobEffects.f_19606_);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.m_9236_();
        if (level.m_46467_() % 20L == 0L && !entity.m_21023_(MobEffects.f_19606_)) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Integer.MAX_VALUE, 0, false, false, true));
        }
        this.updateCooldown(stack, level);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return slotContext.identifier().equals("charm");
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean tryActivateTotem(LivingEntity entity, ItemStack stack, DamageSource damageSource) {
        if (this.isOnCooldown(stack, entity.m_9236_())) {
            return false;
        }
        this.activateTotem(entity, stack);
        return true;
    }

    private void activateTotem(LivingEntity entity, ItemStack stack) {
        Level level = entity.m_9236_();
        entity.m_21153_(1.0f);
        entity.m_21219_();
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
        entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.REVENGE_OF_HORUS.get(), 6000, 0));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Integer.MAX_VALUE, 0, false, false, true));
        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123767_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 30, 0.5, 1.0, 0.5, 0.1);
        }
        this.setCooldown(stack, level);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237115_((String)"item.afterlifeentombed.token_of_horus.activated").m_130940_(ChatFormatting.GOLD), true);
        }
    }

    public boolean isOnCooldown(ItemStack stack, Level level) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(COOLDOWN_TAG)) {
            return false;
        }
        long cooldownEnd = tag.m_128454_(COOLDOWN_TAG);
        return level.m_46467_() < cooldownEnd;
    }

    private void setCooldown(ItemStack stack, Level level) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(COOLDOWN_TAG, level.m_46467_() + 6000L);
    }

    private void updateCooldown(ItemStack stack, Level level) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(COOLDOWN_TAG)) {
            long cooldownEnd = tag.m_128454_(COOLDOWN_TAG);
            if (level.m_46467_() >= cooldownEnd) {
                tag.m_128473_(COOLDOWN_TAG);
            }
        }
    }

    private long getRemainingCooldown(ItemStack stack, Level level) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(COOLDOWN_TAG)) {
            return 0L;
        }
        long cooldownEnd = tag.m_128454_(COOLDOWN_TAG);
        long remaining = cooldownEnd - level.m_46467_();
        return Math.max(0L, remaining);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.token_of_horus.tooltip").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.token_of_horus.resistance").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.token_of_horus.totem_effect").m_130940_(ChatFormatting.AQUA));
        if (level != null) {
            long remainingTicks = this.getRemainingCooldown(stack, level);
            if (remainingTicks > 0L) {
                int remainingSeconds = (int)(remainingTicks / 20L);
                int minutes = remainingSeconds / 60;
                int seconds = remainingSeconds % 60;
                tooltip.add((Component)Component.m_237110_((String)"item.afterlifeentombed.token_of_horus.cooldown", (Object[])new Object[]{String.format("%d:%02d", minutes, seconds)}).m_130940_(ChatFormatting.RED));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.token_of_horus.ready").m_130940_(ChatFormatting.GREEN));
            }
        }
        super.m_7373_(stack, level, tooltip, flag);
    }
}

