/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.mobs;

import com.dracolich777.afterlifeentombed.init.ModBlocks;
import com.dracolich777.afterlifeentombed.init.ModItems;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class GodseekerEntity
extends AbstractVillager {
    private static final EntityDataAccessor<Integer> DATA_UNHAPPY_COUNTER = SynchedEntityData.m_135353_(GodseekerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int TRADE_COOLDOWN = 6000;
    private int tradeTimer = 0;
    private boolean hasTraded = false;

    public GodseekerEntity(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(3, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_UNHAPPY_COUNTER, (Object)0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.tradeTimer > 0) {
                --this.tradeTimer;
            }
            if (this.hasTraded && this.tradeTimer <= 0) {
                this.hasTraded = false;
                this.m_7604_();
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 16.0);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_150930_(Items.f_42601_) && this.m_6084_() && !this.m_35306_() && !this.m_6162_()) {
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7604_() {
        MerchantOffers offers = this.m_6616_();
        this.addOffersFromItemListings(offers, this.getGodseekerTrades(), 20);
    }

    private GodseekerTrade[] getGodseekerTrades() {
        return new GodseekerTrade[]{new GodseekerTrade(new ItemStack((ItemLike)Items.f_42415_, 10), new ItemStack((ItemLike)Items.f_42593_, 1), new ItemStack((ItemLike)ModItems.GODSTONE_OF_RA.get(), 1), 5, 0, 0.05f), new GodseekerTrade(new ItemStack((ItemLike)Items.f_42415_, 10), new ItemStack((ItemLike)Items.f_42740_, 1), new ItemStack((ItemLike)ModItems.GODSTONE_OF_HORUS.get(), 1), 3, 0, 0.05f), new GodseekerTrade(new ItemStack((ItemLike)Items.f_42415_, 10), new ItemStack((ItemLike)Items.f_42517_, 10), new ItemStack((ItemLike)ModItems.GODSTONE_OF_THOTH.get(), 1), 3, 0, 0.05f), new GodseekerTrade(new ItemStack((ItemLike)Items.f_42415_, 10), new ItemStack((ItemLike)Items.f_150994_, 3), new ItemStack((ItemLike)ModItems.GODSTONE_OF_GEB.get(), 1), 3, 0, 0.05f), new GodseekerTrade(new ItemStack((ItemLike)Items.f_42415_, 10), new ItemStack((ItemLike)Items.f_42714_, 3), new ItemStack((ItemLike)ModItems.GODSTONE_OF_SHU.get(), 1), 3, 0, 0.05f), new GodseekerTrade(new ItemStack((ItemLike)Items.f_42415_, 10), new ItemStack((ItemLike)Items.f_42716_, 3), new ItemStack((ItemLike)ModItems.GODSTONE_OF_ISIS.get(), 1), 3, 0, 0.05f), new GodseekerTrade(new ItemStack((ItemLike)Items.f_42415_, 10), new ItemStack((ItemLike)Items.f_41951_, 5), new ItemStack((ItemLike)ModItems.GODSTONE_OF_SETH.get(), 1), 2, 0, 0.05f), new GodseekerTrade(new ItemStack((ItemLike)Items.f_41959_, 2), new ItemStack((ItemLike)Items.f_42758_, 5), new ItemStack((ItemLike)ModItems.GODSTONE_OF_ANUBIS.get(), 1), 3, 0, 0.05f), new GodseekerTrade(new ItemStack((ItemLike)Items.f_42415_, 3), new ItemStack((ItemLike)Items.f_41912_, 20), new ItemStack((ItemLike)ModBlocks.DUSKSAND.get(), 4), 5, 0, 0.05f)};
    }

    protected void addOffersFromItemListings(MerchantOffers offers, GodseekerTrade[] trades, int maxTrades) {
        Random random = new Random();
        offers.clear();
        for (GodseekerTrade trade : trades) {
            if (offers.size() >= maxTrades) break;
            MerchantOffer offer = new MerchantOffer(trade.baseCostA, trade.baseCostB, trade.result, trade.maxUses, trade.xp, trade.priceMultiplier);
            offers.add((Object)offer);
        }
    }

    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean m_7826_() {
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("TradeTimer", this.tradeTimer);
        compound.m_128379_("HasTraded", this.hasTraded);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.tradeTimer = compound.m_128451_("TradeTimer");
        this.hasTraded = compound.m_128471_("HasTraded");
    }

    public void m_6996_(MerchantOffer offer) {
        offer.m_45374_();
        this.f_21363_ = -this.m_8100_();
        this.m_8058_(offer);
        this.hasTraded = true;
        this.tradeTimer = 6000;
    }

    protected void m_8058_(MerchantOffer offer) {
        if (offer.m_45383_()) {
            int xp = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), xp));
        }
    }

    public Vec3 m_7398_(float partialTicks) {
        float f = Mth.m_14179_((float)partialTicks, (float)this.f_20884_, (float)this.f_20883_) * ((float)Math.PI / 180);
        Vec3 vec3 = new Vec3(0.0, this.m_20191_().m_82376_() - 1.0, 0.2);
        return this.m_20318_(partialTicks).m_82549_(vec3.m_82524_(-f));
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public static class GodseekerTrade {
        public final ItemStack baseCostA;
        public final ItemStack baseCostB;
        public final ItemStack result;
        public final int maxUses;
        public final int xp;
        public final float priceMultiplier;

        public GodseekerTrade(ItemStack baseCostA, ItemStack baseCostB, ItemStack result, int maxUses, int xp, float priceMultiplier) {
            this.baseCostA = baseCostA;
            this.baseCostB = baseCostB;
            this.result = result;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public GodseekerTrade(ItemStack baseCostA, ItemStack result, int maxUses, int xp, float priceMultiplier) {
            this(baseCostA, ItemStack.f_41583_, result, maxUses, xp, priceMultiplier);
        }
    }
}

