/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.util;

import com.dracolich777.afterlifeentombed.init.ModBlocks;
import com.dracolich777.afterlifeentombed.init.ModDimensions;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.ITeleporter;

public class DuatTeleporter {
    public static void teleportToCorrespondingPortal(ServerPlayer player, BlockPos currentPortalPos) {
        ServerLevel currentWorld = player.m_284548_();
        if (currentWorld.m_46472_() == ModDimensions.DUAT_KEY) {
            DuatTeleporter.teleportToOverworld(player, currentPortalPos);
        } else {
            DuatTeleporter.teleportToDuat(player, currentPortalPos);
        }
    }

    private static void teleportToOverworld(ServerPlayer player, BlockPos duatPortalPos) {
        BlockPos targetPos;
        ServerLevel overworldWorld = player.m_20194_().m_129880_(Level.f_46428_);
        if (overworldWorld == null) {
            player.m_213846_((Component)Component.m_237113_((String)"Could not access overworld."));
            return;
        }
        BlockPos spawnPos = player.m_8961_();
        ServerLevel spawnWorld = overworldWorld;
        if (spawnPos != null) {
            if (player.m_8963_() != null) {
                ServerLevel respawnWorld = player.m_20194_().m_129880_(player.m_8963_());
                if (respawnWorld != null) {
                    spawnWorld = respawnWorld;
                    if (!player.m_8964_() && !DuatTeleporter.isValidSpawnPoint(spawnWorld, spawnPos)) {
                        spawnPos = spawnWorld.m_220360_();
                    }
                } else {
                    spawnPos = overworldWorld.m_220360_();
                }
            }
            targetPos = spawnPos;
        } else {
            int overworldX = duatPortalPos.m_123341_() * 42;
            int overworldZ = duatPortalPos.m_123343_() * 42;
            targetPos = new BlockPos(overworldX, 64, overworldZ);
        }
        BlockPos safePos = DuatTeleporter.findSafeTeleportPosition(spawnWorld, targetPos);
        if (player.m_9236_() != spawnWorld) {
            player.changeDimension(spawnWorld, (ITeleporter)new PortalTeleporter(safePos));
        } else {
            DuatTeleporter.teleportPlayerSafely(player, safePos);
        }
        player.m_20091_();
        spawnWorld.m_5594_(null, safePos, SoundEvents.f_12287_, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    private static void teleportToDuat(ServerPlayer player, BlockPos overworldPortalPos) {
        ServerLevel duatWorld = player.m_20194_().m_129880_(ModDimensions.DUAT_KEY);
        if (duatWorld == null) {
            player.m_213846_((Component)Component.m_237113_((String)"Could not access Duat dimension."));
            return;
        }
        int duatX = overworldPortalPos.m_123341_() / 42;
        int duatZ = overworldPortalPos.m_123343_() / 42;
        BlockPos duatPortalPos = new BlockPos(duatX, 101, duatZ);
        BlockPos safePos = DuatTeleporter.findSafeTeleportPosition(duatWorld, duatPortalPos);
        if (!duatWorld.m_8055_(duatPortalPos).m_60713_((Block)ModBlocks.DUAT_PORTAL.get())) {
            DuatTeleporter.createDuatPortalFrame(duatWorld, new BlockPos(duatX, 100, duatZ));
            duatWorld.m_7731_(duatPortalPos, ((Block)ModBlocks.DUAT_PORTAL.get()).m_49966_(), 3);
        }
        if (player.m_9236_() != duatWorld) {
            player.changeDimension(duatWorld, (ITeleporter)new PortalTeleporter(safePos));
        } else {
            DuatTeleporter.teleportPlayerSafely(player, safePos);
        }
        player.m_20091_();
        duatWorld.m_5594_(null, safePos, SoundEvents.f_12287_, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    private static boolean isValidSpawnPoint(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof BedBlock) {
            return true;
        }
        if (state.m_60713_(Blocks.f_50724_)) {
            return (Integer)state.m_61143_((Property)RespawnAnchorBlock.f_55833_) > 0;
        }
        return false;
    }

    private static void createDuatPortalFrame(ServerLevel world, BlockPos center) {
        BlockPos[] cornerPositions;
        BlockPos[] crossPositions;
        BlockState core = Blocks.f_50354_.m_49966_();
        BlockState cross = Blocks.f_50396_.m_49966_();
        BlockState corners = Blocks.f_50395_.m_49966_();
        for (BlockPos pos : crossPositions = new BlockPos[]{center.m_122012_(), center.m_122019_(), center.m_122029_(), center.m_122024_()}) {
            world.m_7731_(pos, cross, 3);
        }
        for (BlockPos pos : cornerPositions = new BlockPos[]{center.m_122012_().m_122029_(), center.m_122012_().m_122024_(), center.m_122019_().m_122029_(), center.m_122019_().m_122024_()}) {
            world.m_7731_(pos, corners, 3);
        }
        world.m_7731_(center, core, 3);
    }

    public static void teleportToPosition(ServerPlayer player, ServerLevel targetWorld, BlockPos targetPos) {
        BlockPos safePos = DuatTeleporter.findSafeTeleportPosition(targetWorld, targetPos);
        if (player.m_9236_() != targetWorld) {
            player.changeDimension(targetWorld, (ITeleporter)new PortalTeleporter(safePos));
        } else {
            DuatTeleporter.teleportPlayerSafely(player, safePos);
        }
        player.m_20091_();
        targetWorld.m_5594_(null, safePos, SoundEvents.f_12287_, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    private static BlockPos findSafeTeleportPosition(ServerLevel world, BlockPos portalPos) {
        BlockPos[] candidatePositions;
        for (BlockPos pos : candidatePositions = new BlockPos[]{portalPos.m_7494_(), portalPos.m_122012_().m_7494_(), portalPos.m_122019_().m_7494_(), portalPos.m_122029_().m_7494_(), portalPos.m_122024_().m_7494_(), portalPos.m_6630_(2), portalPos.m_122013_(2).m_7494_(), portalPos.m_122020_(2).m_7494_(), portalPos.m_122030_(2).m_7494_(), portalPos.m_122025_(2).m_7494_()}) {
            if (!DuatTeleporter.isSafePosition(world, pos)) continue;
            return pos;
        }
        BlockPos fallbackPos = portalPos.m_122029_().m_7494_();
        DuatTeleporter.clearAreaForPlayer(world, fallbackPos);
        return fallbackPos;
    }

    private static boolean isSafePosition(ServerLevel world, BlockPos pos) {
        BlockState groundState = world.m_8055_(pos.m_7495_());
        BlockState feetState = world.m_8055_(pos);
        BlockState headState = world.m_8055_(pos.m_7494_());
        return groundState.m_60804_((BlockGetter)world, pos.m_7495_()) && !feetState.m_60804_((BlockGetter)world, pos) && !headState.m_60804_((BlockGetter)world, pos.m_7494_()) && !DuatTeleporter.isHazardousBlock(world, pos) && !DuatTeleporter.isHazardousBlock(world, pos.m_7494_());
    }

    private static boolean isHazardousBlock(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == Blocks.f_49991_ || state.m_60734_() == Blocks.f_50083_ || state.m_60734_() == Blocks.f_50084_ || state.m_60734_() instanceof CactusBlock || state.m_60734_() instanceof MagmaBlock || state.m_60734_() instanceof CampfireBlock || state.m_60734_() instanceof LiquidBlock || state.m_60819_().m_192917_((Fluid)Fluids.f_76195_) || state.m_60819_().m_192917_((Fluid)Fluids.f_76194_);
    }

    private static void clearAreaForPlayer(ServerLevel world, BlockPos pos) {
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        world.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
    }

    private static void teleportPlayerSafely(ServerPlayer player, BlockPos pos) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        player.m_6021_(x, y, z);
        player.m_183634_();
    }

    public static void emergencyTeleport(ServerPlayer player, ServerLevel targetWorld) {
        BlockPos spawnPos = targetWorld.m_220360_();
        BlockPos safePos = DuatTeleporter.findSafeTeleportPosition(targetWorld, spawnPos);
        DuatTeleporter.teleportToPosition(player, targetWorld, safePos);
        player.m_213846_((Component)Component.m_237113_((String)"Emergency teleportation to safe location."));
    }

    public static boolean canTeleportSafely(ServerPlayer player, BlockPos portalPos) {
        BlockPos targetPos;
        ServerLevel currentWorld = player.m_284548_();
        ServerLevel targetWorld = currentWorld.m_46472_() == ModDimensions.DUAT_KEY ? player.m_20194_().m_129880_(Level.f_46428_) : player.m_20194_().m_129880_(ModDimensions.DUAT_KEY);
        if (targetWorld == null) {
            return false;
        }
        if (currentWorld.m_46472_() == ModDimensions.DUAT_KEY) {
            int overworldX = portalPos.m_123341_() * 42;
            int overworldZ = portalPos.m_123343_() * 42;
            targetPos = new BlockPos(overworldX, 64, overworldZ);
        } else {
            int duatX = portalPos.m_123341_() / 42;
            int duatZ = portalPos.m_123343_() / 42;
            targetPos = new BlockPos(duatX, 101, duatZ);
        }
        return targetWorld.m_46749_(targetPos);
    }

    public static Component getTeleportationStatus(ServerPlayer player, BlockPos portalPos) {
        ServerLevel currentWorld = player.m_284548_();
        if (currentWorld.m_46472_() == ModDimensions.DUAT_KEY) {
            return Component.m_237113_((String)("Portal leads to Overworld (spawn point or coordinates " + portalPos.m_123341_() * 42 + ", " + portalPos.m_123343_() * 42 + ")"));
        }
        return Component.m_237113_((String)("Portal leads to Duat (coordinates " + portalPos.m_123341_() / 42 + ", " + portalPos.m_123343_() / 42 + ")"));
    }

    private static class PortalTeleporter
    implements ITeleporter {
        private final BlockPos targetPos;

        public PortalTeleporter(BlockPos targetPos) {
            this.targetPos = targetPos;
        }

        public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            Entity teleportedEntity = repositionEntity.apply(false);
            double x = (double)this.targetPos.m_123341_() + 0.5;
            double y = this.targetPos.m_123342_();
            double z = (double)this.targetPos.m_123343_() + 0.5;
            teleportedEntity.m_7678_(x, y, z, yaw, entity.m_146909_());
            if (teleportedEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)teleportedEntity;
                player.m_183634_();
            }
            return teleportedEntity;
        }
    }
}

