/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.blockentities;

import com.dracolich777.afterlifeentombed.init.ModBlockEntities;
import com.dracolich777.afterlifeentombed.menu.GodHoldMenu;
import com.dracolich777.afterlifeentombed.util.GodHoldInventory;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GodHoldBlockEntity
extends BlockEntity
implements MenuProvider {
    private UUID inventoryId;
    private boolean hasInventoryId = false;

    public GodHoldBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.GODHOLD_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.afterlifeentombed.godhold");
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new GodHoldMenu(pContainerId, pPlayerInventory, this);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_5776_()) {
            return;
        }
        if (!this.hasInventoryId) {
            this.ensureInventoryId((ServerLevel)pLevel);
        }
    }

    private void ensureInventoryId(ServerLevel level) {
        if (this.inventoryId == null) {
            GodHoldInventory data = GodHoldInventory.get(level);
            this.inventoryId = data.createNewInventory();
            this.hasInventoryId = true;
            this.m_6596_();
        }
    }

    public void setInventoryIdFromItem(UUID id) {
        if (!this.hasInventoryId && this.inventoryId == null) {
            this.inventoryId = id;
            this.hasInventoryId = true;
            this.m_6596_();
        }
    }

    public UUID getInventoryId() {
        return this.inventoryId;
    }

    public void setInventoryId(UUID inventoryId) {
        this.inventoryId = inventoryId;
        this.hasInventoryId = true;
        this.m_6596_();
    }

    public NonNullList<ItemStack> getItems() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.inventoryId != null) {
                return GodHoldInventory.get(serverLevel).getInventory(this.inventoryId);
            }
        }
        return NonNullList.m_122780_((int)GodHoldInventory.getInventorySize(), (Object)ItemStack.f_41583_);
    }

    public void setItems(NonNullList<ItemStack> items) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.inventoryId != null) {
                GodHoldInventory.get(serverLevel).setInventory(this.inventoryId, items);
            }
        }
    }

    public ItemStack getItem(int index) {
        NonNullList<ItemStack> items = this.getItems();
        if (items == null || index < 0 || index >= items.size()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = (ItemStack)items.get(index);
        return result != null ? result : ItemStack.f_41583_;
    }

    public void setItem(int index, ItemStack stack) {
        NonNullList<ItemStack> items = this.getItems();
        if (items != null && index >= 0 && index < items.size()) {
            items.set(index, (Object)(stack != null ? stack : ItemStack.f_41583_));
            this.setItems(items);
            this.m_6596_();
        }
    }

    public ItemStack removeItem(int index, int count) {
        NonNullList<ItemStack> items = this.getItems();
        if (items != null && index >= 0 && index < items.size() && !((ItemStack)items.get(index)).m_41619_() && count > 0) {
            ItemStack result = ((ItemStack)items.get(index)).m_41620_(count);
            this.setItems(items);
            this.m_6596_();
            return result;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack removeItemNoUpdate(int index) {
        NonNullList<ItemStack> items = this.getItems();
        if (items != null && index >= 0 && index < items.size()) {
            ItemStack result = (ItemStack)items.get(index);
            items.set(index, (Object)ItemStack.f_41583_);
            this.setItems(items);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public boolean isEmpty() {
        NonNullList<ItemStack> items = this.getItems();
        for (ItemStack stack : items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void clearContent() {
        NonNullList items = NonNullList.m_122780_((int)GodHoldInventory.getInventorySize(), (Object)ItemStack.f_41583_);
        this.setItems((NonNullList<ItemStack>)items);
        this.m_6596_();
    }

    public int getContainerSize() {
        return GodHoldInventory.getInventorySize();
    }

    public void dropContents() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            NonNullList<ItemStack> items = this.getItems();
            for (ItemStack stack : items) {
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
            }
            this.clearContent();
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.inventoryId != null) {
            pTag.m_128359_("InventoryId", this.inventoryId.toString());
        }
        pTag.m_128379_("HasInventoryId", this.hasInventoryId);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("InventoryId")) {
            this.inventoryId = UUID.fromString(pTag.m_128461_("InventoryId"));
        }
        this.hasInventoryId = pTag.m_128471_("HasInventoryId");
    }
}

