/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.blocks;

import com.dracolich777.afterlifeentombed.init.ModBlocks;
import com.dracolich777.afterlifeentombed.init.ModDimensions;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ITeleporter;

public class DuatPortalBlock
extends Block {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public DuatPortalBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60913_(-1.0f, 3600000.0f).m_222994_().m_60953_(state -> 15).m_60910_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.f_46443_ && !entity.m_20159_() && !entity.m_20160_() && entity.m_6072_() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (player.m_20092_()) {
                return;
            }
            world.m_5594_(null, pos, SoundEvents.f_12287_, SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * 0.4f + 0.8f);
            ServerLevel serverWorld = (ServerLevel)world;
            if (serverWorld.m_46472_() == ModDimensions.DUAT_KEY) {
                this.teleportToPlayerSpawn(player);
            } else {
                this.teleportToDuat(player, pos);
            }
        }
    }

    private void teleportToPlayerSpawn(ServerPlayer player) {
        ServerLevel overworldWorld = player.m_20194_().m_129880_(Level.f_46428_);
        if (overworldWorld == null) {
            player.m_213846_((Component)Component.m_237113_((String)"Could not access overworld."));
            return;
        }
        BlockPos spawnPos = player.m_8961_();
        ServerLevel spawnWorld = overworldWorld;
        if (spawnPos != null) {
            if (player.m_8963_() != null) {
                ServerLevel respawnWorld = player.m_20194_().m_129880_(player.m_8963_());
                if (respawnWorld != null) {
                    spawnWorld = respawnWorld;
                    if (!player.m_8964_() && !this.isValidSpawnPoint(spawnWorld, spawnPos)) {
                        spawnPos = spawnWorld.m_220360_();
                    }
                } else {
                    spawnPos = overworldWorld.m_220360_();
                }
            }
        } else {
            spawnPos = spawnWorld.m_220360_();
        }
        BlockPos safePos = this.findSafeTeleportPosition(spawnWorld, spawnPos);
        if (player.m_9236_() != spawnWorld) {
            player.changeDimension(spawnWorld, (ITeleporter)new SpawnTeleporter(safePos));
        } else {
            this.teleportPlayerSafely(player, safePos);
        }
        player.m_20091_();
        spawnWorld.m_5594_(null, safePos, SoundEvents.f_12287_, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    private void teleportToDuat(ServerPlayer player, BlockPos portalPos) {
        ServerLevel duatWorld = player.m_20194_().m_129880_(ModDimensions.DUAT_KEY);
        if (duatWorld == null) {
            player.m_213846_((Component)Component.m_237113_((String)"Could not access Duat dimension."));
            return;
        }
        int duatX = portalPos.m_123341_() / 42;
        int duatZ = portalPos.m_123343_() / 42;
        BlockPos duatPortalPos = new BlockPos(duatX, 101, duatZ);
        BlockPos safePos = this.findSafeTeleportPosition(duatWorld, duatPortalPos);
        if (!duatWorld.m_8055_(duatPortalPos).m_60713_((Block)ModBlocks.DUAT_PORTAL.get())) {
            this.createDuatPortalFrame(duatWorld, new BlockPos(duatX, 100, duatZ));
            duatWorld.m_7731_(duatPortalPos, ((Block)ModBlocks.DUAT_PORTAL.get()).m_49966_(), 3);
        }
        if (player.m_9236_() != duatWorld) {
            player.changeDimension(duatWorld, (ITeleporter)new SpawnTeleporter(safePos));
        } else {
            this.teleportPlayerSafely(player, safePos);
        }
        player.m_20091_();
        duatWorld.m_5594_(null, safePos, SoundEvents.f_12287_, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    private boolean isValidSpawnPoint(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof BedBlock) {
            return true;
        }
        if (state.m_60713_(Blocks.f_50724_)) {
            return (Integer)state.m_61143_((Property)RespawnAnchorBlock.f_55833_) > 0;
        }
        return false;
    }

    private void createDuatPortalFrame(ServerLevel world, BlockPos center) {
        BlockPos[] cornerPositions;
        BlockPos[] crossPositions;
        BlockState core = Blocks.f_50354_.m_49966_();
        BlockState cross = Blocks.f_50396_.m_49966_();
        BlockState corners = Blocks.f_50395_.m_49966_();
        for (BlockPos pos : crossPositions = new BlockPos[]{center.m_122012_(), center.m_122019_(), center.m_122029_(), center.m_122024_()}) {
            world.m_7731_(pos, cross, 3);
        }
        for (BlockPos pos : cornerPositions = new BlockPos[]{center.m_122012_().m_122029_(), center.m_122012_().m_122024_(), center.m_122019_().m_122029_(), center.m_122019_().m_122024_()}) {
            world.m_7731_(pos, corners, 3);
        }
        world.m_7731_(center, core, 3);
    }

    private BlockPos findSafeTeleportPosition(ServerLevel world, BlockPos portalPos) {
        BlockPos[] candidatePositions;
        for (BlockPos pos : candidatePositions = new BlockPos[]{portalPos.m_7494_(), portalPos.m_122012_().m_7494_(), portalPos.m_122019_().m_7494_(), portalPos.m_122029_().m_7494_(), portalPos.m_122024_().m_7494_(), portalPos.m_6630_(2), portalPos.m_122013_(2).m_7494_(), portalPos.m_122020_(2).m_7494_(), portalPos.m_122030_(2).m_7494_(), portalPos.m_122025_(2).m_7494_()}) {
            if (!this.isSafePosition(world, pos)) continue;
            return pos;
        }
        BlockPos fallbackPos = portalPos.m_122029_().m_7494_();
        this.clearAreaForPlayer(world, fallbackPos);
        return fallbackPos;
    }

    private boolean isSafePosition(ServerLevel world, BlockPos pos) {
        BlockState groundState = world.m_8055_(pos.m_7495_());
        BlockState feetState = world.m_8055_(pos);
        BlockState headState = world.m_8055_(pos.m_7494_());
        return groundState.m_60804_((BlockGetter)world, pos.m_7495_()) && !feetState.m_60804_((BlockGetter)world, pos) && !headState.m_60804_((BlockGetter)world, pos.m_7494_()) && !this.isHazardousBlock(world, pos) && !this.isHazardousBlock(world, pos.m_7494_());
    }

    private boolean isHazardousBlock(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == Blocks.f_49991_ || state.m_60734_() == Blocks.f_50083_ || state.m_60734_() == Blocks.f_50084_ || state.m_60734_() instanceof CactusBlock || state.m_60734_() instanceof MagmaBlock || state.m_60734_() instanceof CampfireBlock || state.m_60734_() instanceof LiquidBlock || state.m_60819_().m_192917_((Fluid)Fluids.f_76195_) || state.m_60819_().m_192917_((Fluid)Fluids.f_76194_);
    }

    private void clearAreaForPlayer(ServerLevel world, BlockPos pos) {
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        world.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
    }

    private void teleportPlayerSafely(ServerPlayer player, BlockPos pos) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        player.m_6021_(x, y, z);
        player.m_183634_();
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!DuatPortalBlock.isValidPortalFrame(world, pos)) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            world.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static boolean isValidPortalFrame(Level world, BlockPos portalPos) {
        BlockPos[] cornerPositions;
        BlockPos[] crossPositions;
        BlockPos frameCenter = portalPos.m_7495_();
        BlockState centerState = world.m_8055_(frameCenter);
        if (!centerState.m_60713_((Block)ModBlocks.DUSKSTEEL.get()) && !centerState.m_60713_(Blocks.f_50354_)) {
            return false;
        }
        for (BlockPos pos : crossPositions = new BlockPos[]{frameCenter.m_122012_(), frameCenter.m_122019_(), frameCenter.m_122029_(), frameCenter.m_122024_()}) {
            BlockState state = world.m_8055_(pos);
            if (state.m_60713_(Blocks.f_50074_) || state.m_60713_(Blocks.f_50396_)) continue;
            return false;
        }
        for (BlockPos pos : cornerPositions = new BlockPos[]{frameCenter.m_122012_().m_122029_(), frameCenter.m_122012_().m_122024_(), frameCenter.m_122019_().m_122029_(), frameCenter.m_122019_().m_122024_()}) {
            BlockState state = world.m_8055_(pos);
            if (state.m_60713_(Blocks.f_50063_) || state.m_60713_(Blocks.f_50395_)) continue;
            return false;
        }
        return true;
    }

    private static class SpawnTeleporter
    implements ITeleporter {
        private final BlockPos targetPos;

        public SpawnTeleporter(BlockPos targetPos) {
            this.targetPos = targetPos;
        }

        public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            Entity teleportedEntity = repositionEntity.apply(false);
            double x = (double)this.targetPos.m_123341_() + 0.5;
            double y = this.targetPos.m_123342_();
            double z = (double)this.targetPos.m_123343_() + 0.5;
            teleportedEntity.m_7678_(x, y, z, yaw, entity.m_146909_());
            if (teleportedEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)teleportedEntity;
                player.m_183634_();
            }
            return teleportedEntity;
        }
    }
}

