/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.client;

import com.dracolich777.afterlifeentombed.effects.RevengeOfAnubisEffect;
import com.dracolich777.afterlifeentombed.init.ModEffects;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="afterlifeentombed", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FrozenHeartsMechanics {
    @SubscribeEvent
    public static void onPlayerHeal(LivingHealEvent event) {
        float healAmount;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        MobEffectInstance effect = player.m_21124_((MobEffect)ModEffects.REVENGE_OF_ANUBIS.get());
        if (effect == null) {
            return;
        }
        float effectiveMaxHealth = RevengeOfAnubisEffect.getEffectiveMaxHealth((LivingEntity)player);
        float currentHealth = player.m_21223_();
        if (currentHealth + (healAmount = event.getAmount()) > effectiveMaxHealth) {
            float allowedHeal = Math.max(0.0f, effectiveMaxHealth - currentHealth);
            event.setAmount(allowedHeal);
            if (allowedHeal <= 0.0f) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        MobEffectInstance effect = player.m_21124_((MobEffect)ModEffects.REVENGE_OF_ANUBIS.get());
        if (effect == null) {
            return;
        }
        float effectiveMaxHealth = RevengeOfAnubisEffect.getEffectiveMaxHealth((LivingEntity)player);
        float currentHealth = player.m_21223_();
        float damage = event.getAmount();
        float minHealthAfterDamage = Math.max(0.0f, currentHealth - damage);
        if (currentHealth >= effectiveMaxHealth && damage < 0.0f) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11983_, SoundSource.PLAYERS, 0.5f, 1.5f);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        MobEffectInstance effect = player.m_21124_((MobEffect)ModEffects.REVENGE_OF_ANUBIS.get());
        if (effect == null) {
            return;
        }
        float effectiveMaxHealth = RevengeOfAnubisEffect.getEffectiveMaxHealth((LivingEntity)player);
        if (player.m_21223_() > effectiveMaxHealth) {
            player.m_21153_(effectiveMaxHealth);
        }
        if (!(player.m_21223_() >= effectiveMaxHealth) || player.m_36324_().m_38722_() > 0.0f) {
            // empty if block
        }
    }
}

