/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.events;

import com.dracolich777.afterlifeentombed.init.ModItems;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="afterlifeentombed", value={Dist.CLIENT})
public class DoubleJumpHandler {
    private static final Map<UUID, Boolean> hasDoubleJumped = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> wasOnGround = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Integer> jumpCooldown = new HashMap<UUID, Integer>();

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int currentCooldown;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!(event.player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)event.player;
        UUID playerId = player.m_20148_();
        boolean hasBreathOfShu = CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findFirstCurio((Item)ModItems.BREATH_OF_SHU.get()).isPresent()).orElse(false);
        if (!hasBreathOfShu) {
            hasDoubleJumped.remove(playerId);
            wasOnGround.remove(playerId);
            jumpCooldown.remove(playerId);
            return;
        }
        boolean currentlyOnGround = player.m_20096_();
        boolean previouslyOnGround = wasOnGround.getOrDefault(playerId, true);
        if (currentlyOnGround && !previouslyOnGround) {
            hasDoubleJumped.put(playerId, false);
            jumpCooldown.put(playerId, 0);
        }
        if ((currentCooldown = jumpCooldown.getOrDefault(playerId, 0).intValue()) > 0) {
            jumpCooldown.put(playerId, currentCooldown - 1);
        }
        if (!(currentlyOnGround || previouslyOnGround || hasDoubleJumped.getOrDefault(playerId, false).booleanValue() || !player.f_108618_.f_108572_ || player.m_20069_() || player.m_20077_() || currentCooldown != 0 || !(player.m_20184_().f_82480_ < 0.1))) {
            player.m_20334_(player.m_20184_().f_82479_, 0.6, player.m_20184_().f_82481_);
            hasDoubleJumped.put(playerId, true);
            jumpCooldown.put(playerId, 10);
            player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11893_, SoundSource.PLAYERS, 0.5f, 1.5f, false);
        }
        wasOnGround.put(playerId, currentlyOnGround);
    }
}

