/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.events;

import com.dracolich777.afterlifeentombed.AfterlifeEntombedMod;
import com.dracolich777.afterlifeentombed.init.ModEntityTypes;
import com.dracolich777.afterlifeentombed.mobs.GodseekerEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="afterlifeentombed")
public class GodseekerRitualPattern {
    private static final Map<BlockPos, Block> RITUAL_PATTERN = new HashMap<BlockPos, Block>();
    private static final long RITUAL_COOLDOWN_TICKS = 12000L;
    private static final Map<BlockPos, Long> ritualCooldowns;

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.getLevel().m_5776_() || !(event.getLevel() instanceof ServerLevel)) {
            AfterlifeEntombedMod.LOGGER.debug("BlockPlaceEvent fired on client side or not a ServerLevel, skipping. Block: {}", (Object)event.getPlacedBlock().m_60734_().m_49954_().getString());
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockPos placedPos = event.getPos();
        BlockState placedState = event.getPlacedBlock();
        if (!placedState.m_60713_(Blocks.f_50312_) && !placedState.m_60713_(Blocks.f_50310_)) {
            AfterlifeEntombedMod.LOGGER.debug("Placed block is not a skull, skipping ritual check. Block: {}", (Object)placedState.m_60734_().m_49954_().getString());
            return;
        }
        AfterlifeEntombedMod.LOGGER.info("Skull placed at {}! Initiating ritual pattern check.", (Object)placedPos);
        BlockPos basePos = placedPos.m_7918_(0, -3, 0);
        if (ritualCooldowns.containsKey(basePos) && level.m_46467_() < ritualCooldowns.get(basePos)) {
            AfterlifeEntombedMod.LOGGER.info("Ritual location {} is on cooldown. Remaining ticks: {}", (Object)basePos, (Object)(ritualCooldowns.get(basePos) - level.m_46467_()));
            return;
        }
        if (GodseekerRitualPattern.checkPattern((Level)level, placedPos)) {
            AfterlifeEntombedMod.LOGGER.info("Pattern matched successfully at {}! Summoning Godseeker...", (Object)placedPos);
            GodseekerRitualPattern.performGodseekerSummon(level, placedPos);
            ritualCooldowns.put(basePos, level.m_46467_() + 12000L);
            AfterlifeEntombedMod.LOGGER.info("Ritual cooldown set for {} ticks at {}.", (Object)12000L, (Object)basePos);
        } else {
            AfterlifeEntombedMod.LOGGER.info("Pattern mismatch at skull position: {}. Ritual failed.", (Object)placedPos);
        }
    }

    private static boolean checkPattern(Level level, BlockPos skullPos) {
        AfterlifeEntombedMod.LOGGER.info("Starting pattern check for skull at: {}. World Time: {}", (Object)skullPos, (Object)level.m_46467_());
        for (Map.Entry<BlockPos, Block> entry : RITUAL_PATTERN.entrySet()) {
            BlockPos relativePos = entry.getKey();
            Block requiredBlock = entry.getValue();
            BlockPos worldPos = skullPos.m_121955_((Vec3i)relativePos);
            BlockState actualState = level.m_8055_(worldPos);
            AfterlifeEntombedMod.LOGGER.info("  Checking relative: {} (World: {}) - Expected: {}, Found: {}", (Object)relativePos, (Object)worldPos, (Object)requiredBlock.m_49954_().getString(), (Object)actualState.m_60734_().m_49954_().getString());
            if (actualState.m_60713_(requiredBlock)) continue;
            AfterlifeEntombedMod.LOGGER.warn("  PATTERN MISMATCH! At world position {}: Expected {}, Found {}. Ritual failed.", (Object)worldPos, (Object)requiredBlock.m_49954_().getString(), (Object)actualState.m_60734_().m_49954_().getString());
            return false;
        }
        AfterlifeEntombedMod.LOGGER.info("All blocks in pattern matched successfully for skull at {}.", (Object)skullPos);
        return true;
    }

    private static void performGodseekerSummon(ServerLevel level, BlockPos skullPos) {
        AfterlifeEntombedMod.LOGGER.info("Executing Godseeker summon ritual at: {}", (Object)skullPos);
        for (Map.Entry<BlockPos, Block> entry : RITUAL_PATTERN.entrySet()) {
            BlockPos relativePos = entry.getKey();
            BlockPos worldPos = skullPos.m_121955_((Vec3i)relativePos);
            level.m_46597_(worldPos, Blocks.f_50016_.m_49966_());
            AfterlifeEntombedMod.LOGGER.debug("Removed block at: {}", (Object)worldPos);
        }
        level.m_46597_(skullPos, Blocks.f_50016_.m_49966_());
        AfterlifeEntombedMod.LOGGER.debug("Removed skull at: {}", (Object)skullPos);
        level.m_5594_(null, skullPos, SoundEvents.f_12053_, SoundSource.MASTER, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        level.m_5594_(null, skullPos, SoundEvents.f_215769_, SoundSource.MASTER, 1.5f, 0.5f + level.f_46441_.m_188501_() * 0.4f);
        AfterlifeEntombedMod.LOGGER.info("Playing ritual sounds.");
        GodseekerEntity godseeker = (GodseekerEntity)((EntityType)ModEntityTypes.GODSEEKER.get()).m_20615_((Level)level);
        if (godseeker != null) {
            godseeker.m_6034_((double)skullPos.m_123341_() + 0.5, (double)skullPos.m_123342_() + 0.1, (double)skullPos.m_123343_() + 0.5);
            level.m_7967_((Entity)godseeker);
            godseeker.m_21530_();
            godseeker.m_21557_(false);
            godseeker.m_21553_(false);
            AfterlifeEntombedMod.LOGGER.info("Godseeker summoned at: {}", (Object)godseeker.m_20183_());
            level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)skullPos.m_123341_() + 0.5, (double)skullPos.m_123342_() + 0.5, (double)skullPos.m_123343_() + 0.5, 50, 0.5, 0.5, 0.5, 0.05);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123747_, (double)skullPos.m_123341_() + 0.5, (double)skullPos.m_123342_() + 0.5, (double)skullPos.m_123343_() + 0.5, 5, 0.0, 0.0, 0.0, 0.0);
            AfterlifeEntombedMod.LOGGER.info("Spawning particles.");
        } else {
            AfterlifeEntombedMod.LOGGER.error("Failed to create Godseeker entity! ModEntityTypes.GODSEEKER.get() returned null.");
        }
    }

    static {
        RITUAL_PATTERN.put(new BlockPos(0, -1, 0), Blocks.f_50063_);
        RITUAL_PATTERN.put(new BlockPos(0, -2, 0), Blocks.f_50074_);
        RITUAL_PATTERN.put(new BlockPos(0, -3, 0), Blocks.f_50064_);
        RITUAL_PATTERN.put(new BlockPos(1, -1, 0), Blocks.f_50074_);
        RITUAL_PATTERN.put(new BlockPos(-1, -1, 0), Blocks.f_50074_);
        RITUAL_PATTERN.put(new BlockPos(0, -1, 1), Blocks.f_50074_);
        RITUAL_PATTERN.put(new BlockPos(0, -1, -1), Blocks.f_50074_);
        ritualCooldowns = new ConcurrentHashMap<BlockPos, Long>();
    }
}

