/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.events;

import com.dracolich777.afterlifeentombed.init.ModBlocks;
import com.dracolich777.afterlifeentombed.init.ModDimensions;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="afterlifeentombed")
public class PortalActivationHandler {
    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        BlockPos belowPos;
        Entity entity;
        if (event.getLevel().m_5776_() || !((entity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level world = (Level)levelAccessor;
        BlockPos pos = event.getPos();
        BlockState placedState = event.getPlacedBlock();
        if (placedState.m_60713_((Block)ModBlocks.DUSKSTEEL.get()) && PortalActivationHandler.isValidPortalPattern(world, pos)) {
            PortalActivationHandler.activatePortal(world, pos);
        }
        if (placedState.m_60713_(Blocks.f_50083_) && world.m_8055_(belowPos = pos.m_7495_()).m_60713_((Block)ModBlocks.DUSKSTEEL.get()) && PortalActivationHandler.isValidPortalPattern(world, belowPos)) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            PortalActivationHandler.activatePortal(world, belowPos);
        }
    }

    private static boolean isValidPortalPattern(Level world, BlockPos center) {
        BlockPos[] cornerPositions;
        BlockPos[] goldPositions;
        if (!world.m_8055_(center).m_60713_((Block)ModBlocks.DUSKSTEEL.get())) {
            return false;
        }
        for (BlockPos pos : goldPositions = new BlockPos[]{center.m_122012_(), center.m_122019_(), center.m_122029_(), center.m_122024_()}) {
            if (world.m_8055_(pos).m_60713_(Blocks.f_50074_)) continue;
            return false;
        }
        for (BlockPos pos : cornerPositions = new BlockPos[]{center.m_122012_().m_122029_(), center.m_122012_().m_122024_(), center.m_122019_().m_122029_(), center.m_122019_().m_122024_()}) {
            if (world.m_8055_(pos).m_60713_(Blocks.f_50063_)) continue;
            return false;
        }
        return true;
    }

    private static void activatePortal(Level world, BlockPos center) {
        if (world.m_46472_() == Level.f_46429_ || world.m_46472_() == Level.f_46430_) {
            return;
        }
        BlockPos portalPos = center.m_7494_();
        if (!world.m_8055_(portalPos).m_60713_((Block)ModBlocks.DUAT_PORTAL.get())) {
            world.m_7731_(portalPos, ((Block)ModBlocks.DUAT_PORTAL.get()).m_49966_(), 3);
        }
        if (world.m_46472_() == Level.f_46428_) {
            PortalActivationHandler.createDuatPortal(world, center);
        }
        world.m_5594_(null, center, SoundEvents.f_12288_, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.m_5594_(null, center, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void createDuatPortal(Level world, BlockPos originalPos) {
        int duatZ;
        if (world.f_46443_) {
            return;
        }
        ServerLevel duatWorld = world.m_7654_().m_129880_(ModDimensions.DUAT_KEY);
        if (duatWorld == null) {
            return;
        }
        int duatX = originalPos.m_123341_() / 42;
        BlockPos duatFramePos = new BlockPos(duatX, 100, duatZ = originalPos.m_123343_() / 42);
        BlockPos duatPortalPos = duatFramePos.m_7494_();
        if (!duatWorld.m_8055_(duatPortalPos).m_60713_((Block)ModBlocks.DUAT_PORTAL.get())) {
            PortalActivationHandler.createPortalFrame((Level)duatWorld, duatFramePos);
            duatWorld.m_7731_(duatPortalPos, ((Block)ModBlocks.DUAT_PORTAL.get()).m_49966_(), 3);
        }
    }

    private static void createPortalFrame(Level world, BlockPos center) {
        BlockPos[] cornerPositions;
        BlockPos[] crossPositions;
        BlockState corners;
        BlockState cross;
        BlockState core;
        if (world.m_46472_() == ModDimensions.DUAT_KEY) {
            core = Blocks.f_50354_.m_49966_();
            cross = Blocks.f_50396_.m_49966_();
            corners = Blocks.f_50395_.m_49966_();
        } else {
            core = ((Block)ModBlocks.DUSKSTEEL.get()).m_49966_();
            cross = Blocks.f_50074_.m_49966_();
            corners = Blocks.f_50063_.m_49966_();
        }
        for (BlockPos pos : crossPositions = new BlockPos[]{center.m_122012_(), center.m_122019_(), center.m_122029_(), center.m_122024_()}) {
            world.m_7731_(pos, cross, 3);
        }
        for (BlockPos pos : cornerPositions = new BlockPos[]{center.m_122012_().m_122029_(), center.m_122012_().m_122024_(), center.m_122019_().m_122029_(), center.m_122019_().m_122024_()}) {
            world.m_7731_(pos, corners, 3);
        }
        world.m_7731_(center, core, 3);
    }
}

