/*
 * Decompiled with CFR 0.152.
 */
package com.dracolich777.afterlifeentombed.items;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class RingOfRa
extends Item
implements ICurioItem {
    private static final Map<BlockPos, Long> temporaryMagmaBlocks = new HashMap<BlockPos, Long>();
    private static final int MAGMA_BLOCK_DURATION = 100;

    public RingOfRa(Item.Properties properties) {
        super(properties);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12032_, SoundSource.PLAYERS, 1.0f, 1.0f);
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, Integer.MAX_VALUE, 0, false, false, true));
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        entity.m_21195_(MobEffects.f_19607_);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.m_9236_();
        if (level.m_46467_() % 20L == 0L && !entity.m_21023_(MobEffects.f_19607_)) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, Integer.MAX_VALUE, 0, false, false, true));
        }
        this.cleanupExpiredMagmaBlocks(level);
        if (entity.m_20096_() || entity.m_20077_()) {
            this.createLavaWalkingBlocks(entity, level);
        }
    }

    private void createLavaWalkingBlocks(LivingEntity entity, Level level) {
        if (level.f_46443_) {
            return;
        }
        BlockPos entityPos = entity.m_20183_();
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos checkPos = entityPos.m_7918_(x, 0, z);
                BlockPos belowPos = checkPos.m_7495_();
                BlockState currentState = level.m_8055_(checkPos);
                BlockState belowState = level.m_8055_(belowPos);
                if (currentState.m_60713_(Blocks.f_49991_) && (Integer)currentState.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                    if (!level.m_8055_(checkPos.m_7494_()).m_60795_() && !level.m_8055_(checkPos.m_7494_()).m_247087_()) continue;
                    this.createTemporaryMagmaBlock(level, checkPos);
                    continue;
                }
                if (!belowState.m_60713_(Blocks.f_49991_) || (Integer)belowState.m_61143_((Property)LiquidBlock.f_54688_) != 0 || !currentState.m_60795_() && !currentState.m_247087_()) continue;
                this.createTemporaryMagmaBlock(level, belowPos);
            }
        }
    }

    private void createTemporaryMagmaBlock(Level level, BlockPos pos) {
        if (temporaryMagmaBlocks.containsKey(pos)) {
            return;
        }
        level.m_7731_(pos, Blocks.f_50450_.m_49966_(), 3);
        temporaryMagmaBlocks.put(pos, level.m_46467_());
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.3f, 2.0f);
        if (level.f_46443_) {
            for (int i = 0; i < 8; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.8, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.8, 0.0, 0.1, 0.0);
            }
        }
    }

    public void cleanupExpiredMagmaBlocks(Level level) {
        if (level.f_46443_) {
            return;
        }
        long currentTime = level.m_46467_();
        Iterator<Map.Entry<BlockPos, Long>> iterator = temporaryMagmaBlocks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Long> entry = iterator.next();
            BlockPos pos = entry.getKey();
            long creationTime = entry.getValue();
            if (currentTime - creationTime < 100L) continue;
            if (level.m_8055_(pos).m_60713_(Blocks.f_50450_)) {
                level.m_7731_(pos, Blocks.f_49991_.m_49966_(), 3);
                level.m_5594_(null, pos, SoundEvents.f_11773_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            iterator.remove();
        }
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        String slotId = slotContext.identifier();
        return slotId.equals("charm") || slotId.equals("ring");
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean m_5812_(ItemStack pStack) {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.ring_of_ra.tooltip").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.ring_of_ra.effect").m_130940_(ChatFormatting.RED));
        tooltip.add((Component)Component.m_237115_((String)"item.afterlifeentombed.ring_of_ra.lava_walking").m_130940_(ChatFormatting.YELLOW));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

